/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IJavaWebServiceElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.WorkspaceCUFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.AbstractModelSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

public class OnEventModelSynchronizer
extends AbstractModelSynchronizer
implements IElementChangedListener {
    public IDOM getDomBeingLoaded() {
        return this.resource().getDOM();
    }

    public OnEventModelSynchronizer(JaxWsWorkspaceResource resource, JaxWsWorkspaceResource.ServiceModelData serviceData) {
        super(resource, serviceData);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (this.logger().isDebug()) {
                this.logger().logDebug("ElementChangedEvent has been delivered. Event details: " + event.toString());
            }
            if (this.resource().isLoadCnaceled()) {
                return;
            }
            this.resource().disableSaving();
            if (event.getType() == 4) {
                this.handleReconcileEvent(event);
            }
            if (event.getDelta().getElement() != this.resource().javaModel()) {
                return;
            }
            try {
                assert ((event.getDelta().getFlags() & 9) != 0);
                IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta child = iJavaElementDeltaArray[n2];
                    if (child.getElement() instanceof IJavaProject) {
                        this.handleChangedProject(child);
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                this.logger().logError("Unable to synchronize Web Service model upon java element delta " + event.getDelta(), (Throwable)ce);
            }
            catch (WsDOMLoadCanceledException e) {
                this.logger().logError("Unable to synchronize Web Service model upon java element delta " + event.getDelta(), (Throwable)e);
            }
        }
        finally {
            this.resource().enableSaving();
        }
    }

    protected void handleReconcileEvent(ElementChangedEvent event) throws JavaModelException {
        if (!(event.getDelta().getElement() instanceof ICompilationUnit)) {
            return;
        }
        int requiredFlags = 9;
        if ((event.getDelta().getFlags() & requiredFlags) == 0) {
            return;
        }
        ICompilationUnit cu = (ICompilationUnit)event.getDelta().getElement();
        if (!this.resource().approveProject(cu.getJavaProject())) {
            return;
        }
        if (this.isJavaResource(cu)) {
            this.handleChangedContentCompilationUnit(cu);
        }
    }

    private boolean isJavaResource(ICompilationUnit cu) throws JavaModelException {
        ICompilationUnit javaElement = cu;
        while ((javaElement = javaElement.getParent()) != null) {
            if (javaElement.exists()) continue;
            return false;
        }
        return true;
    }

    void handleChangedProject(IJavaElementDelta projectDelta) throws CoreException, WsDOMLoadCanceledException {
        assert (projectDelta.getElement() instanceof IJavaProject);
        if (((projectDelta.getFlags() & 0x400) != 0 || projectDelta.getKind() == 2) && this.util().findProjectByName(this.getDomBeingLoaded(), projectDelta.getElement().getElementName()) != null) {
            this.handleClosedProject(projectDelta);
        }
        if (!this.resource().approveProject((IJavaProject)projectDelta.getElement())) {
            return;
        }
        if ((projectDelta.getFlags() & 0x200) != 0 || projectDelta.getKind() == 1) {
            this.handleOpenedProject(projectDelta);
        }
        IJavaElementDelta[] iJavaElementDeltaArray = projectDelta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getElement() instanceof IPackageFragmentRoot) {
                if ((childDelta.getFlags() & 0x40) != 0) {
                    this.handleClosedProject(projectDelta);
                    this.handleOpenedProject(projectDelta);
                }
                if ((childDelta.getFlags() & 0x80) != 0) {
                    this.handleClosedProject(projectDelta);
                    this.handleOpenedProject(projectDelta);
                }
                if ((childDelta.getFlags() & 8) != 0) {
                    this.recursevilyHandleRemovedPackages(childDelta);
                    this.recursevilyHandleAddedPackages(childDelta);
                    this.recursevilyHandleCompilationUnits(childDelta);
                }
            }
            ++n2;
        }
    }

    protected void recursevilyHandleAddedPackages(IJavaElementDelta rootDelta) throws JavaModelException {
        IWebServiceProject wsPrj = this.findProjectByDelta(rootDelta);
        if (wsPrj == null) {
            return;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = rootDelta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getElement() instanceof IPackageFragment && childDelta.getKind() == 1) {
                ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)childDelta.getElement()).getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit cu = iCompilationUnitArray[n4];
                    this.processCompilationUnit(wsPrj, cu);
                    ++n4;
                }
                this.recursevilyHandleAddedPackages(childDelta);
            }
            ++n2;
        }
    }

    protected IWebServiceProject findProjectByDelta(IJavaElementDelta rootDelta) {
        return this.util().findProjectByName(this.getDomBeingLoaded(), rootDelta.getElement().getJavaProject().getElementName());
    }

    private void recursevilyHandleRemovedPackages(IJavaElementDelta rootDelta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = rootDelta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getElement() instanceof IPackageFragment) {
                if (childDelta.getKind() == 2) {
                    IWebServiceProject wsPrj = this.findProjectByDelta(rootDelta);
                    if (wsPrj != null) {
                        this.removeModelElements(wsPrj, childDelta.getElement().getElementName(), true);
                    }
                } else {
                    this.recursevilyHandleRemovedPackages(childDelta);
                }
            }
            ++n2;
        }
    }

    private void handleOpenedProject(IJavaElementDelta projectDelta) throws CoreException, WsDOMLoadCanceledException {
        assert (projectDelta.getElement() instanceof IJavaProject);
        IJavaProject changedProject = (IJavaProject)projectDelta.getElement();
        this.newProjectCUFinder(changedProject).find(null, new AbstractModelSynchronizer.LoaderCompilationUnitHandler());
    }

    private void handleClosedProject(IJavaElementDelta projectDelta) throws CoreException {
        assert (projectDelta.getElement() instanceof IJavaProject);
        IWebServiceProject wsPrj = this.util().findProjectByName(this.getDomBeingLoaded(), projectDelta.getElement().getElementName());
        if (wsPrj == null) {
            return;
        }
        for (IServiceEndpointInterface sei : wsPrj.getServiceEndpointInterfaces()) {
            sei.getImplementingWebServices().clear();
        }
        for (IWebService ws : wsPrj.getWebServices()) {
            this.serviceData().unmap(ws);
        }
        this.getDomBeingLoaded().getWebServiceProjects().remove((Object)wsPrj);
    }

    private ICompilationUnitFinder newProjectCUFinder(final IJavaProject prj) {
        return new WorkspaceCUFinder(this.resource().javaModel(), new IProjectSelector[]{new IProjectSelector(){

            public boolean approve(IJavaProject toApprove) {
                return prj.getElementName().equals(toApprove.getElementName());
            }
        }});
    }

    private void recursevilyHandleCompilationUnits(IJavaElementDelta delta) {
        if (delta.getElement() instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            if (this.util().findProjectByName(this.getDomBeingLoaded(), cu.getJavaProject().getElementName()) == null) {
                return;
            }
            try {
                if (delta.getKind() == 1 && (delta.getFlags() & 0x10) == 0) {
                    this.handleAddedCompilationUnit(cu);
                }
                if (delta.getKind() == 2 && (delta.getFlags() & 0x20) == 0) {
                    this.handleRemovedCompilationUnit(cu);
                }
                if (delta.getKind() == 2 && (delta.getFlags() & 0x20) != 0) {
                    this.handleMovedToCompilationUnit(cu, (ICompilationUnit)delta.getMovedToElement());
                }
                if (delta.getKind() == 4 && (delta.getFlags() & 0x40000) != 0 || (delta.getFlags() & 0x10000) != 0) {
                    this.handleChangedContentCompilationUnit(cu);
                }
            }
            catch (JavaModelException jme) {
                this.logger().logError("Unable to parse the content of compilation unit" + delta.getElement(), (Throwable)jme);
            }
        } else {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                this.recursevilyHandleCompilationUnits(childDelta);
                ++n2;
            }
        }
    }

    private void handleChangedContentCompilationUnit(ICompilationUnit cu) throws JavaModelException {
        IAnnotation annotation;
        IType type = cu.findPrimaryType();
        IAnnotation iAnnotation = annotation = type == null ? null : this.resource().newAnnotationInspector(type).inspectType("javax.jws.WebService");
        if (type == null || annotation == null) {
            this.updateSubclassingWSElements(cu);
            this.handleRemovedCompilationUnit(cu);
        } else {
            IWebServiceProject wsProject = this.util().findProjectByName(this.getDomBeingLoaded(), cu.getJavaProject().getElementName());
            assert (wsProject != null);
            this.processCompilationUnit(wsProject, cu);
        }
    }

    private void updateSubclassingWSElements(ICompilationUnit cu) throws JavaModelException {
        for (IWebServiceProject wsPrj : this.getDomBeingLoaded().getWebServiceProjects()) {
            IJavaProject javaPrj = this.javaModel().getJavaProject(wsPrj.getName());
            for (IServiceEndpointInterface sei : wsPrj.getServiceEndpointInterfaces()) {
                if (this.serviceData().getHierarchy(sei.getImplementation()) == null || !this.serviceData().getHierarchy(sei.getImplementation()).contains(cu)) continue;
                this.processCompilationUnit(wsPrj, javaPrj.findType(sei.getImplementation()).getCompilationUnit());
            }
            for (IWebService ws : wsPrj.getWebServices()) {
                if (this.serviceData().getHierarchy(ws.getImplementation()) == null || !this.serviceData().getHierarchy(ws.getImplementation()).contains(cu)) continue;
                this.processCompilationUnit(wsPrj, javaPrj.findType(ws.getImplementation()).getCompilationUnit());
            }
        }
    }

    private void handleAddedCompilationUnit(ICompilationUnit addedCU) throws JavaModelException {
        IWebServiceProject wsPrj = this.util().findProjectByName(this.getDomBeingLoaded(), addedCU.getJavaProject().getElementName());
        this.processCompilationUnit(wsPrj, addedCU);
    }

    void handleMovedToCompilationUnit(ICompilationUnit fromCU, ICompilationUnit toCU) throws JavaModelException {
        boolean fqNameChanged;
        IJavaWebServiceElement wsElem = this.guessContainedWSElement(fromCU);
        if (wsElem == null) {
            return;
        }
        boolean bl = fqNameChanged = !toCU.getElementName().equals(fromCU.getElementName()) || !toCU.getParent().getElementName().equals(fromCU.getParent().getElementName());
        if (fqNameChanged) {
            this.handleRemovedCompilationUnit(fromCU);
            this.handleAddedCompilationUnit(toCU);
        } else {
            IWebServiceProject toPrj = this.util().findProjectByName(this.getDomBeingLoaded(), toCU.getJavaProject().getElementName());
            if (wsElem instanceof IWebService) {
                toPrj.getWebServices().add((Object)((IWebService)wsElem));
            } else {
                toPrj.getServiceEndpointInterfaces().add((Object)((IServiceEndpointInterface)wsElem));
            }
        }
    }

    private void handleRemovedCompilationUnit(ICompilationUnit remCU) throws JavaModelException {
        IWebServiceProject wsPrj = this.util().findProjectByName(this.getDomBeingLoaded(), remCU.getJavaProject().getElementName());
        this.removeModelElements(wsPrj, this.guessPrimaryTypeName(remCU), false);
    }

    private void removeModelElements(IWebServiceProject wsPrj, String implBaseName, boolean isForPackage) throws JavaModelException {
        if (wsPrj == null) {
            return;
        }
        this.removeWsModelElements(wsPrj, implBaseName, isForPackage);
        this.removeSeiModelElements(wsPrj, implBaseName, isForPackage, false);
    }

    private IJavaWebServiceElement guessContainedWSElement(ICompilationUnit cu) {
        IWebServiceProject wsPrj = this.util().findProjectByName(this.getDomBeingLoaded(), cu.getJavaProject().getElementName());
        return this.util().findJavaWebServiceElemByImplName(wsPrj, this.guessPrimaryTypeName(cu));
    }

    protected String guessPrimaryTypeName(ICompilationUnit cu) {
        String parentName = cu.getParent().getElementName();
        StringBuilder assumedPrimaryTypeName = new StringBuilder();
        if (parentName.length() > 0) {
            assumedPrimaryTypeName.append(parentName).append('.');
        }
        return assumedPrimaryTypeName.append(cu.getElementName()).delete(assumedPrimaryTypeName.lastIndexOf(".java"), assumedPrimaryTypeName.length()).toString();
    }
}

