/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateObjectChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ObjectChangeTrackingPolicy
extends DeferredChangeDetectionPolicy {
    @Override
    public void dissableEventProcessing(Object changeTracker) {
        ObjectChangeListener listener = (ObjectChangeListener)((ChangeTracker)changeTracker)._persistence_getPropertyChangeListener();
        if (listener != null) {
            listener.ignoreEvents();
        }
    }

    @Override
    public void enableEventProcessing(Object changeTracker) {
        ObjectChangeListener listener = (ObjectChangeListener)((ChangeTracker)changeTracker)._persistence_getPropertyChangeListener();
        if (listener != null) {
            listener.processEvents();
        }
    }

    @Override
    public boolean shouldCompareExistingObjectForChange(Object object, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor) {
        ObjectChangeListener listener = (ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener();
        if (listener != null && listener.hasChanges()) {
            return true;
        }
        Boolean optimisticRead = null;
        if (unitOfWork.hasOptimisticReadLockObjects() && (optimisticRead = (Boolean)unitOfWork.getOptimisticReadLockObjects().get(object)) != null) {
            return true;
        }
        return descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getForceUpdate();
    }

    @Override
    public void raiseInternalPropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
        ObjectChangeListener listener = (ObjectChangeListener)((ChangeTracker)source)._persistence_getPropertyChangeListener();
        if (listener != null) {
            listener.internalPropertyChange(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
        }
    }

    @Override
    public void setAggregateChangeListener(Object parent, Object aggregate, UnitOfWorkImpl uow, ClassDescriptor descriptor, String mappingAttribute) {
        ((ChangeTracker)aggregate)._persistence_setPropertyChangeListener(new AggregateObjectChangeListener((ObjectChangeListener)((ChangeTracker)parent)._persistence_getPropertyChangeListener(), mappingAttribute));
    }

    @Override
    public PropertyChangeListener setChangeListener(Object clone, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        ObjectChangeListener listener = new ObjectChangeListener();
        ((ChangeTracker)clone)._persistence_setPropertyChangeListener(listener);
        return listener;
    }

    @Override
    public void clearChanges(Object clone, UnitOfWorkImpl uow, ClassDescriptor descriptor, boolean forRefresh) {
        ObjectChangeListener listener = (ObjectChangeListener)((ChangeTracker)clone)._persistence_getPropertyChangeListener();
        if (listener != null) {
            listener.clearChanges(forRefresh);
        } else {
            listener = (ObjectChangeListener)this.setChangeListener(clone, uow, descriptor);
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        if (!builder.isSimple()) {
            this.dissableEventProcessing(clone);
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(clone);
            List<DatabaseMapping> mappings = builder.getRelationshipMappings();
            int size = mappings.size();
            int index = 0;
            while (index < size) {
                DatabaseMapping mapping = mappings.get(index);
                if (!isPartialObject || fetchGroupManager.isAttributeFetched(clone, mapping.getAttributeName())) {
                    mapping.setChangeListener(clone, listener, uow);
                }
                ++index;
            }
            this.enableEventProcessing(clone);
        }
    }

    @Override
    public void initialize(AbstractSession session, ClassDescriptor descriptor) {
        Class javaClass = descriptor.getJavaClass();
        if (!ChangeTracker.class.isAssignableFrom(javaClass)) {
            session.getIntegrityChecker().handleError(DescriptorException.needToImplementChangeTracker(descriptor));
        }
    }

    @Override
    public boolean isDeferredChangeDetectionPolicy() {
        return false;
    }

    @Override
    public boolean isObjectChangeTrackingPolicy() {
        return true;
    }
}

