/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.xpath.ui.internal.views.EditNamespacePrefixDialog;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceSelectionAdapter
extends SelectionAdapter {
    protected Map<Document, List<NamespaceInfo>> namespaceInfo;

    public NamespaceSelectionAdapter(Map<Document, List<NamespaceInfo>> namespaces) {
        this.namespaceInfo = namespaces;
    }

    public void widgetSelected(SelectionEvent e) {
        IEditorPart activeEditor = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFile file = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IDOMModel model = null;
        try {
            try {
                model = (IDOMModel)modelManager.getModelForRead(file);
                IDOMDocument document = model.getDocument();
                if (document != null) {
                    List<NamespaceInfo> info = this.createNamespaceInfo((Document)document);
                    IPathEditorInput editorInput = (IPathEditorInput)activeEditor.getEditorInput();
                    EditNamespacePrefixDialog dlg = new EditNamespacePrefixDialog(activeEditor.getSite().getShell(), editorInput.getPath());
                    dlg.setNamespaceInfoList(info);
                    dlg.open();
                }
            }
            catch (Exception exception) {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private List<NamespaceInfo> createNamespaceInfo(Document document) {
        List<NamespaceInfo> info = this.namespaceInfo.get(document);
        if (info == null) {
            info = new ArrayList<NamespaceInfo>();
            NamespaceTable namespaceTable = new NamespaceTable(document);
            namespaceTable.visitElement(document.getDocumentElement());
            Collection namespaces = namespaceTable.getNamespaceInfoCollection();
            info.addAll(namespaces);
            this.namespaceInfo.put(document, info);
        }
        return info;
    }
}

