/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests.rules;

import junit.framework.TestCase;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class ScannerColumnTest
extends TestCase {
    private IDocument fDocument;

    protected void setUp() throws Exception {
        this.fDocument = new Document("scanner test");
    }

    protected void tearDown() throws Exception {
        this.fDocument = null;
    }

    public void testRuleBasedScannerColumnRead() {
        this._testScannerColumnRead(new RuleBasedScanner());
    }

    public void testRuleBasedScannerColumnUnread() {
        this._testScannerColumnUnread(new RuleBasedScanner());
    }

    public void testBufferedRuleBasedScannerColumnRead() {
        this._testScannerColumnRead((RuleBasedScanner)new BufferedRuleBasedScanner(100));
    }

    public void testBufferedRuleBasedScannerColumnUnread() {
        this._testScannerColumnUnread((RuleBasedScanner)new BufferedRuleBasedScanner(100));
    }

    private void _testScannerColumnRead(RuleBasedScanner scanner) {
        scanner.setRange(this.fDocument, 0, 10);
        ScannerColumnTest.assertEquals((int)0, (int)scanner.getColumn());
        ScannerColumnTest.assertEquals((int)115, (int)scanner.read());
        ScannerColumnTest.assertEquals((int)1, (int)scanner.getColumn());
        scanner.unread();
        ScannerColumnTest.assertEquals((int)0, (int)scanner.getColumn());
    }

    private void _testScannerColumnUnread(RuleBasedScanner scanner) {
        scanner.setRange(this.fDocument, 0, 10);
        ScannerColumnTest.assertEquals((int)0, (int)scanner.getColumn());
        ScannerColumnTest.assertEquals((int)115, (int)scanner.read());
        ScannerColumnTest.assertEquals((int)1, (int)scanner.getColumn());
        scanner.unread();
        ScannerColumnTest.assertEquals((int)0, (int)scanner.getColumn());
    }
}

