/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeContainerTests
extends TestCase {
    private static final String CONTENT_1 = "<root><a id='a'></a></root>";
    private static final String CONTENT_2 = "<root><a id='a'><b id='b'></b></a></root>";

    public NodeContainerTests() {
        super("Test NodeContainer");
    }

    public NodeContainerTests(String name) {
        super(name);
    }

    public void testAppendValidChild() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(CONTENT_1);
        IDOMDocument doc = model.getDocument();
        Element a = doc.getElementById("a");
        NodeContainerTests.assertNotNull((String)"Could not find element with id 'a' in <root><a id='a'></a></root>", (Object)a);
        Element b = doc.createElement("b");
        b.setAttribute("id", "b");
        try {
            a.appendChild(b);
        }
        catch (DOMException dOMException) {
            NodeContainerTests.fail((String)("Should have been able to append " + b + " as a child of " + a));
        }
    }

    public void testAppendParentAsChildOfChild() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(CONTENT_2);
        IDOMDocument doc = model.getDocument();
        Element a = doc.getElementById("a");
        NodeContainerTests.assertNotNull((String)"Could not find element with id 'a' in <root><a id='a'><b id='b'></b></a></root>", (Object)a);
        Element b = doc.getElementById("b");
        NodeContainerTests.assertNotNull((String)"Could not find element with id 'b' in <root><a id='a'><b id='b'></b></a></root>", (Object)b);
        boolean threwException = false;
        try {
            b.appendChild(a);
        }
        catch (DOMException e) {
            NodeContainerTests.assertEquals((String)("Wrong type of exception was thrown: " + e), (short)3, (short)e.code);
            threwException = true;
        }
        NodeContainerTests.assertTrue((String)"A DOMException with code HIERARCHY_REQUEST_ERR should have been thrown when appending a parent to its own child", (boolean)threwException);
    }

    public void testReplaceChild() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(CONTENT_1);
        IDOMDocument doc = model.getDocument();
        Element a = doc.getElementById("a");
        NodeContainerTests.assertNotNull((String)"Could not find element with id 'a' in <root><a id='a'></a></root>", (Object)a);
        Element root = (Element)a.getParentNode();
        NodeContainerTests.assertNotNull((String)"Could not find parent node 'root'", (Object)root);
        Node replaced = root.replaceChild(a, a);
        NodeContainerTests.assertTrue((String)"Not replaced is not the same as 'a'", (a == replaced ? 1 : 0) != 0);
        NodeContainerTests.assertTrue((String)"Child of root is not 'a'", (root.getFirstChild() == a ? 1 : 0) != 0);
    }
}

