/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.xml.ws.WebServiceRef;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class RemoveAnnotationFromFieldTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.xml.ws.WebServiceRef;\n\n");
        classContents.append("public class MyClass {\n\n\t@WebServiceRef()\n\tstatic String service;\n\n}");
        return classContents.toString();
    }

    public Annotation getAnnotation() {
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebServiceRef.class.getSimpleName(), null);
    }

    public void testRemoveAnnotationFromField() {
        try {
            RemoveAnnotationFromFieldTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromFieldTest.assertEquals((String)WebServiceRef.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IField field = this.source.findPrimaryType().getField("service");
            RemoveAnnotationFromFieldTest.assertNotNull((Object)field);
            RemoveAnnotationFromFieldTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            RemoveAnnotationFromFieldTest.assertNotNull((Object)this.source.getImport(WebServiceRef.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)field, (Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)field, (String)WebServiceRef.class.getCanonicalName()));
            RemoveAnnotationFromFieldTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            RemoveAnnotationFromFieldTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            RemoveAnnotationFromFieldTest.assertFalse((String)("import statement for " + WebServiceRef.class.getCanonicalName() + " was still there"), (boolean)this.source.getImport(WebServiceRef.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            RemoveAnnotationFromFieldTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

