/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.JSFConverterUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.util.JSFUIPluginResourcesUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MessagesTagConverter
extends AbstractTagConverter {
    private static final String MESSAGE_CONTENT = JSFUIPluginResourcesUtil.getInstance().getString("MessageTagConverter.defaultValue");
    private static final String MESSAGE_TOOLTIP = JSFUIPluginResourcesUtil.getInstance().getString("MessageTagConverter.defaultTooltip");

    public MessagesTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        Element hostEle = this.getHostElement();
        String layout = hostEle.getAttribute("layout");
        if ("table".equalsIgnoreCase(layout)) {
            Element table = this.createElement("table");
            table.setAttribute("border", "1");
            int i = 0;
            while (i < 2) {
                Element tr = this.createElement("tr");
                Element td = this.createElement("td");
                Element span = this.createSpan();
                td.appendChild(span);
                tr.appendChild(td);
                table.appendChild(tr);
                ++i;
            }
            return table;
        }
        Element ul = this.createElement("ul");
        int i = 0;
        while (i < 2) {
            Element li = this.createElement("li");
            Element span = this.createSpan();
            li.appendChild(span);
            ul.appendChild(li);
            ++i;
        }
        return ul;
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return true;
    }

    public boolean needBorderDecorator() {
        return true;
    }

    private Element createSpan() {
        Element hostEle = this.getHostElement();
        Element spanEle = this.createElement("span");
        JSFConverterUtil.copyAllAttributes((Element)hostEle, (Element)spanEle, null);
        JSFConverterUtil.copyAttribute((Element)hostEle, (String)"styleClass", (Element)spanEle, (String)"class");
        spanEle.removeAttribute("styleClass");
        String fatalStyle = hostEle.getAttribute("fatalStyle");
        String errorStyle = hostEle.getAttribute("errorStyle");
        String warnStyle = hostEle.getAttribute("warnStyle");
        String infoStyle = hostEle.getAttribute("infoStyle");
        String fatalClass = hostEle.getAttribute("fatalClass");
        String errorClass = hostEle.getAttribute("errorClass");
        String warnClass = hostEle.getAttribute("warnClass");
        String infoClass = hostEle.getAttribute("infoClass");
        if (!"".equals(fatalStyle) && fatalStyle != null) {
            spanEle.setAttribute("style", fatalStyle);
        } else if (!"".equals(errorStyle) && errorStyle != null) {
            spanEle.setAttribute("style", errorStyle);
        } else if (!"".equals(warnStyle) && warnStyle != null) {
            spanEle.setAttribute("style", warnStyle);
        } else if (!"".equals(infoStyle) && infoStyle != null) {
            spanEle.setAttribute("style", infoStyle);
        }
        if (!"".equals(fatalClass) && fatalClass != null) {
            spanEle.setAttribute("styleClass", fatalClass);
        } else if (!"".equals(errorClass) && errorClass != null) {
            spanEle.setAttribute("styleClass", errorClass);
        } else if (!"".equals(warnClass) && warnClass != null) {
            spanEle.setAttribute("styleClass", warnClass);
        } else if (!"".equals(infoClass) && infoClass != null) {
            spanEle.setAttribute("styleClass", infoClass);
        }
        String hasToolTip = hostEle.getAttribute("tooltip");
        String showSummary = hostEle.getAttribute("showSummary");
        if ("true".equalsIgnoreCase(hasToolTip) && "true".equalsIgnoreCase(showSummary)) {
            spanEle.setAttribute("title", MESSAGE_TOOLTIP);
        }
        Text text = this.createText(MESSAGE_CONTENT);
        spanEle.appendChild(text);
        return spanEle;
    }
}

