/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

public abstract class BinaryQueryAnnotation
extends BinaryAnnotation
implements QueryAnnotation {
    String name = this.buildName();
    final Vector<QueryHintAnnotation> hints = this.buildHints();

    protected BinaryQueryAnnotation(JavaResourceModel parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public void update() {
        super.update();
        this.setName_(this.buildName());
        this.updateHints();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    private void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return (String)this.getJdtMemberValue(this.getNameElementName());
    }

    public abstract String getNameElementName();

    @Override
    public TextRange getNameTextRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterable<QueryHintAnnotation> getHints() {
        return IterableTools.cloneLive(this.hints);
    }

    @Override
    public int getHintsSize() {
        return this.hints.size();
    }

    @Override
    public QueryHintAnnotation hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public QueryHintAnnotation addHint(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeHint(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<QueryHintAnnotation> buildHints() {
        Object[] jdtHints = this.getJdtMemberValues(this.getHintsElementName());
        Vector<QueryHintAnnotation> result = new Vector<QueryHintAnnotation>(jdtHints.length);
        Object[] objectArray = jdtHints;
        int n = jdtHints.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtHint = objectArray[n2];
            result.add(new BinaryQueryHintAnnotation((JavaResourceModel)this, (IAnnotation)jdtHint));
            ++n2;
        }
        return result;
    }

    public abstract String getHintsElementName();

    private void updateHints() {
        throw new UnsupportedOperationException();
    }
}

