/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

final class FacetModuleCoreSupportDelegate {
    private static final String SLASH = "/";
    private static final String JST_WEB_MODULE = "jst.web";
    private static final String JST_WEBFRAGMENT_MODULE = "jst.webfragment";

    FacetModuleCoreSupportDelegate() {
    }

    static float getDynamicWebProjectVersion(IProject project) {
        if (project == null) {
            return -1.0f;
        }
        float version = -1.0f;
        try {
            IProjectFacet webModuleFacet;
            IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
            if (faceted != null && ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_MODULE) && faceted.hasProjectFacet(webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_MODULE))) {
                version = Float.parseFloat(faceted.getInstalledVersion(webModuleFacet).getVersionString());
            }
        }
        catch (NumberFormatException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return version;
    }

    static IPath getRuntimePath(IPath path) {
        if (path == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        if (virtualResources != null && virtualResources.length > 0) {
            return virtualResources[0].getRuntimePath();
        }
        return null;
    }

    static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists() && component.getRootFolder() != null) {
            path = component.getRootFolder().getWorkspaceRelativePath();
            if (component.getRootFolder().getFolder(FacetModuleCoreSupport.META_INF_RESOURCES_PATH).getUnderlyingFolder().isAccessible()) {
                path = path.append(FacetModuleCoreSupport.META_INF_RESOURCES_PATH);
            }
        }
        return path;
    }

    static boolean isDynamicWebProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            if (ProjectFacetsManager.isProjectFacetDefined((String)JST_WEB_MODULE)) {
                IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
                IProjectFacet webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEB_MODULE);
                if (faceted != null && faceted.hasProjectFacet(webModuleFacet)) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    static boolean isWebFragmentProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            if (ProjectFacetsManager.isProjectFacetDefined((String)JST_WEBFRAGMENT_MODULE)) {
                IFacetedProject faceted = ProjectFacetsManager.create((IProject)project);
                IProjectFacet webModuleFacet = ProjectFacetsManager.getProjectFacet((String)JST_WEBFRAGMENT_MODULE);
                if (faceted != null && faceted.hasProjectFacet(webModuleFacet)) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    private static IPath resolveInReferenced(IProject project, IPath runtimeReference) {
        IVirtualReference[] references = ComponentCore.createComponent((IProject)project).getReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                IVirtualFolder rootFolder;
                IVirtualComponent component;
                IVirtualComponent referencedComponent = references[i].getReferencedComponent();
                if (referencedComponent != null && (component = referencedComponent.getComponent()) != null && (rootFolder = component.getRootFolder()) != null) {
                    IVirtualResource member;
                    IPath referencedPathRoot = rootFolder.getWorkspaceRelativePath();
                    if (referencedPathRoot != null) {
                        IVirtualFolder virtualFolder;
                        IPath resolved = referencedPathRoot.append("META-INF/resources/").append(runtimeReference);
                        if (resolved != null && component.getProject().findMember(resolved.removeFirstSegments(1)) != null) {
                            return resolved;
                        }
                        IVirtualFile virtualFile = ComponentCore.createFile((IProject)component.getProject(), (IPath)FacetModuleCoreSupport.META_INF_RESOURCES_PATH.append(runtimeReference));
                        if (virtualFile != null) {
                            IFile[] underlyingFiles = virtualFile.getUnderlyingFiles();
                            int j = 0;
                            while (j < underlyingFiles.length) {
                                if (underlyingFiles[i].isAccessible()) {
                                    return underlyingFiles[i].getFullPath();
                                }
                                ++j;
                            }
                        }
                        if ((virtualFolder = ComponentCore.createFolder((IProject)component.getProject(), (IPath)FacetModuleCoreSupport.META_INF_RESOURCES_PATH.append(runtimeReference))) != null) {
                            IContainer[] underlyingFolders = virtualFolder.getUnderlyingFolders();
                            int j = 0;
                            while (j < underlyingFolders.length) {
                                if (underlyingFolders[i].isAccessible()) {
                                    return underlyingFolders[i].getFullPath();
                                }
                                ++j;
                            }
                        }
                    }
                    if ((member = rootFolder.findMember(runtimeReference)) != null) {
                        return member.getWorkspaceRelativePath();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    static IPath resolve(IPath basePath, String reference) {
        if (reference == null || basePath == null || basePath.segmentCount() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.segment(0));
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        if (basePath.segmentCount() > 1) {
            IResource baseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(basePath);
            if (baseResource != null) {
                IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)baseResource);
                int i = 0;
                while (i < virtualResources.length) {
                    Path referenceRuntimePath = null;
                    if (reference.startsWith(SLASH)) {
                        referenceRuntimePath = new Path(reference);
                    } else {
                        IPath baseRuntimePath = virtualResources[i].getRuntimePath();
                        referenceRuntimePath = baseRuntimePath.removeLastSegments(1).append(reference);
                    }
                    IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)referenceRuntimePath);
                    if (virtualFile != null && virtualFile.exists()) {
                        IFile[] underlyingFiles = virtualFile.getUnderlyingFiles();
                        int j = 0;
                        while (j < underlyingFiles.length) {
                            if (underlyingFiles[j].isAccessible()) {
                                return underlyingFiles[j].getFullPath();
                            }
                            ++j;
                        }
                        if (underlyingFiles.length > 0) {
                            return underlyingFiles[0].getFullPath();
                        }
                    } else {
                        IVirtualFolder virtualFolder = ComponentCore.createFolder((IProject)project, (IPath)referenceRuntimePath);
                        if (virtualFolder != null && virtualFolder.exists()) {
                            IContainer[] underlyingFolders = virtualFolder.getUnderlyingFolders();
                            int j = 0;
                            while (j < underlyingFolders.length) {
                                if (underlyingFolders[j].isAccessible()) {
                                    return underlyingFolders[j].getFullPath();
                                }
                                ++j;
                            }
                            if (underlyingFolders.length > 0) {
                                return underlyingFolders[0].getFullPath();
                            }
                        } else {
                            return FacetModuleCoreSupportDelegate.resolveInReferenced(project, (IPath)referenceRuntimePath);
                        }
                    }
                    ++i;
                }
            }
        } else {
            IVirtualFile virtualFile = ComponentCore.createFile((IProject)project, (IPath)new Path(reference));
            if (virtualFile != null && virtualFile.exists()) {
                return virtualFile.getUnderlyingFile().getFullPath();
            }
        }
        return null;
    }

    static IPath[] getAcceptableRootPaths(IProject project) {
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return new IPath[]{project.getFullPath()};
        }
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IVirtualFolder componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT);
        if (componentFolder != null && componentFolder.exists()) {
            IContainer[] workspaceFolders = componentFolder.getUnderlyingFolders();
            int i = 0;
            while (i < workspaceFolders.length) {
                if (workspaceFolders[i].getFolder(FacetModuleCoreSupport.META_INF_RESOURCES_PATH).isAccessible()) {
                    paths.add(workspaceFolders[i].getFullPath().append(FacetModuleCoreSupport.META_INF_RESOURCES_PATH));
                } else {
                    paths.add(workspaceFolders[i].getFullPath());
                }
                ++i;
            }
            IVirtualReference[] references = ComponentCore.createComponent((IProject)project).getReferences();
            if (references != null) {
                int i2 = 0;
                while (i2 < references.length) {
                    IPath resourcesPath;
                    IPath referencedPathRoot;
                    IVirtualFolder rootFolder;
                    IVirtualComponent component;
                    IVirtualComponent referencedComponent = references[i2].getReferencedComponent();
                    if (referencedComponent != null && (component = referencedComponent.getComponent()) != null && (rootFolder = component.getRootFolder()) != null && (referencedPathRoot = rootFolder.getWorkspaceRelativePath()) != null && (resourcesPath = referencedPathRoot.append("META-INF/resources/")) != null && component.getProject().findMember(resourcesPath.removeFirstSegments(1)) != null) {
                        paths.add(resourcesPath);
                    }
                    ++i2;
                }
            }
        } else {
            paths.add(project.getFullPath());
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    static IPath getDefaultRoot(IProject project) {
        IVirtualFolder componentFolder;
        if (ModuleCoreNature.isFlexibleProject((IProject)project) && (componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT)) != null && componentFolder.exists()) {
            return componentFolder.getWorkspaceRelativePath();
        }
        return null;
    }

    static IProject[] getReferenced(IProject current) {
        if (!ModuleCoreNature.isFlexibleProject((IProject)current)) {
            return new IProject[0];
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        IVirtualReference[] references = ComponentCore.createComponent((IProject)current).getReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                IProject project;
                IVirtualComponent referencedComponent = references[i].getReferencedComponent();
                if (referencedComponent != null && (project = referencedComponent.getProject()) != null && !project.equals((Object)current)) {
                    projects.add(project);
                }
                ++i;
            }
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    static IPath getRootContainerForPath(IProject project, IPath path) {
        IVirtualFolder componentFolder;
        if (ModuleCoreNature.isFlexibleProject((IProject)project) && (componentFolder = ComponentCore.createFolder((IProject)project, (IPath)Path.ROOT)) != null && componentFolder.exists()) {
            IContainer[] workspaceFolders = componentFolder.getUnderlyingFolders();
            int i = 0;
            while (i < workspaceFolders.length) {
                if (workspaceFolders[i].getFullPath().isPrefixOf(path)) {
                    return workspaceFolders[i].getFullPath();
                }
                ++i;
            }
        }
        return null;
    }
}

