/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClasspathLibraryExpander
extends FlatVirtualComponent {
    private IVirtualReference consumedRef;

    public ClasspathLibraryExpander(IVirtualComponent component) {
        super(component);
    }

    public ClasspathLibraryExpander(IVirtualComponent component, IVirtualReference reference) {
        super(component);
        this.consumedRef = reference;
    }

    protected boolean canOptimize() {
        return true;
    }

    protected void optimize(List<IFlatResource> resources, List<IChildModuleReference> children) {
        if (this.getComponent() != null) {
            VirtualComponentFlattenUtility util = new VirtualComponentFlattenUtility(resources, (VirtualComponentFlattenUtility.ShouldIncludeUtilityCallback)this);
            try {
                if (this.consumedRef != null) {
                    this.consumeComponent(util, (IPath)new Path(""), this.consumedRef);
                } else {
                    this.addConsumedReferences(util, this.getComponent(), (IPath)new Path(""));
                }
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
    }

    public List<IFlatFile> fetchFlatFiles() throws CoreException {
        IFlatResource[] resources = this.fetchResources();
        ArrayList<IFlatFile> flatFiles = new ArrayList<IFlatFile>();
        return this.fetchFlatFiles(resources, flatFiles);
    }

    private List<IFlatFile> fetchFlatFiles(IFlatResource[] resources, List<IFlatFile> flatFiles) {
        int i = 0;
        while (i < resources.length) {
            IFlatResource resource = resources[i];
            if (resource instanceof IFlatFile) {
                flatFiles.add((IFlatFile)resource);
            } else if (resource instanceof IFlatFolder) {
                this.fetchFlatFiles(((IFlatFolder)resource).members(), flatFiles);
            }
            ++i;
        }
        return flatFiles;
    }

    public IFlatResource fetchResource(IPath runtimePath) throws CoreException {
        IFlatResource[] resources = this.fetchResources();
        return this.fetchResource(runtimePath.makeRelative(), resources);
    }

    private IFlatResource fetchResource(IPath runtimePath, IFlatResource[] resources) {
        IFlatResource[] iFlatResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IFlatResource resource = iFlatResourceArray[n2];
            IPath fullResourcePath = resource.getModuleRelativePath().append(resource.getName());
            if (fullResourcePath.equals((Object)runtimePath)) {
                return resource;
            }
            if (fullResourcePath.isPrefixOf(runtimePath) && resource instanceof IFlatFolder) {
                IFlatFolder folder = (IFlatFolder)resource;
                return this.fetchResource(runtimePath, folder.members());
            }
            ++n2;
        }
        return null;
    }
}

