/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.jface.PluggableTextLabelProvider;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.graphics.Image;

public class ResourceManagerLabelProvider<E>
extends PluggableTextLabelProvider<E> {
    private volatile Transformer<E, ImageDescriptor> imageDescriptorTransformer;
    private final ResourceManager resourceManager;

    public ResourceManagerLabelProvider() {
        this(JFaceResources.getResources());
    }

    public ResourceManagerLabelProvider(ResourceManager resourceManager) {
        this(TransformerTools.nullOutputTransformer(), resourceManager);
    }

    public ResourceManagerLabelProvider(Transformer<E, ImageDescriptor> imageDescriptorTransformer, ResourceManager resourceManager) {
        this(imageDescriptorTransformer, TransformerTools.objectToStringTransformer(), resourceManager);
    }

    public ResourceManagerLabelProvider(Transformer<E, ImageDescriptor> imageDescriptorTransformer, Transformer<E, String> textTransformer, ResourceManager resourceManager) {
        super(textTransformer);
        if (imageDescriptorTransformer == null || resourceManager == null) {
            throw new NullPointerException();
        }
        this.imageDescriptorTransformer = imageDescriptorTransformer;
        this.resourceManager = new LocalResourceManager(resourceManager);
    }

    @Override
    public Image getImage(Object element) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(element);
        return imageDescriptor == null ? null : this.resourceManager.createImage(imageDescriptor);
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        return (ImageDescriptor)this.imageDescriptorTransformer.transform(element);
    }

    public void setImageDescriptorTransformer(Transformer<E, ImageDescriptor> imageDescriptorTransformer) {
        if (imageDescriptorTransformer == null) {
            throw new NullPointerException();
        }
        this.imageDescriptorTransformer = imageDescriptorTransformer;
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

