/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.IncludeEntry;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.FolderChange;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.ProjectChange;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.ScriptChange;

public class Refactoring {
    public static ILaunchConfiguration[] NO_CONFIGS = new ILaunchConfiguration[0];
    public static IncludeEntry[] NO_ENTRIES = new IncludeEntry[0];

    public static Change createChangesForProjectRename(IProject project, String newname) {
        ILaunchConfiguration[] configs = Refactoring.getConfigurationsScopedTo(project.getFullPath().makeAbsolute().toString());
        if (configs.length < 1) {
            return null;
        }
        ArrayList<ProjectChange> changes = new ArrayList<ProjectChange>(configs.length);
        int i = 0;
        while (i < configs.length) {
            changes.add(new ProjectChange(configs[i], project.getName(), newname));
            ++i;
        }
        return Refactoring.createChangeFromList(changes, Messages.multi_updates);
    }

    public static Change createChangesForScriptRename(IFile script, String newname) {
        String scriptname = script.getFullPath().makeAbsolute().toString();
        ILaunchConfiguration[] configs = Refactoring.getConfigurationsScopedTo(scriptname);
        if (configs.length < 1) {
            return null;
        }
        ArrayList<ScriptChange> changes = new ArrayList<ScriptChange>(configs.length);
        int i = 0;
        while (i < configs.length) {
            changes.add(new ScriptChange(configs[i], scriptname, newname));
            ++i;
        }
        return Refactoring.createChangeFromList(changes, Messages.multi_updates);
    }

    public static Change createChangesForFolderRename(IFolder folder, String newname) {
        String foldername = folder.getFullPath().makeAbsolute().toString();
        ILaunchConfiguration[] configs = Refactoring.getConfigurationsScopedTo(foldername);
        if (configs.length < 1) {
            return null;
        }
        ArrayList<FolderChange> changes = new ArrayList<FolderChange>(configs.length);
        int i = 0;
        while (i < configs.length) {
            changes.add(new FolderChange(configs[i], foldername, newname));
            ++i;
        }
        return Refactoring.createChangeFromList(changes, Messages.multi_updates);
    }

    public static IResource[] getResources(ILaunchConfiguration configuration) {
        ArrayList<IFile> resources = new ArrayList<IFile>(2);
        try {
            IFile script = Refactoring.getScript(configuration);
            if (script != null) {
                resources.add(script);
            }
        }
        catch (CoreException ce) {
            RhinoUIPlugin.log(ce);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IFile getScript(ILaunchConfiguration configuration) throws CoreException {
        String name = configuration.getAttribute("script", "");
        if (!"".equals(name)) {
            Path spath = new Path(name);
            IResource script = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)spath);
            if (script != null && script.getType() == 1) {
                return (IFile)script;
            }
        }
        return null;
    }

    public static void mapResources(ILaunchConfigurationWorkingCopy configuration) {
        IResource[] resources = Refactoring.getResources((ILaunchConfiguration)configuration);
        if (resources.length < 1) {
            configuration.setMappedResources(null);
        } else {
            configuration.setMappedResources(resources);
        }
    }

    public static Change createChangeFromList(List changes, String changeLabel) {
        int count = changes.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return (Change)changes.get(0);
        }
        return new CompositeChange(changeLabel, changes.toArray(new Change[changes.size()]));
    }

    public static ILaunchConfiguration[] getRhinoConfigurations() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = lm.getLaunchConfigurationType("org.eclipse.wst.jsdt.debug.rhino.ui.launch.config.type");
        if (type != null) {
            try {
                return lm.getLaunchConfigurations(type);
            }
            catch (CoreException coreException) {}
        }
        return NO_CONFIGS;
    }

    public static ILaunchConfiguration[] getConfigurationsScopedTo(String elementpath) {
        if (elementpath == null) {
            return NO_CONFIGS;
        }
        ILaunchConfiguration[] configs = Refactoring.getRhinoConfigurations();
        ArrayList<ILaunchConfiguration> scoped = new ArrayList<ILaunchConfiguration>(4);
        List includes = null;
        String script = null;
        int i = 0;
        while (i < configs.length) {
            try {
                script = configs[i].getAttribute("script", "");
                if (elementpath.equals(script) || script.indexOf(elementpath) > -1) {
                    scoped.add(configs[i]);
                } else {
                    includes = configs[i].getAttribute("includepath", null);
                    if (includes != null && Refactoring.hasIncludeEntryFor(includes, elementpath)) {
                        scoped.add(configs[i]);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return scoped.toArray(new ILaunchConfiguration[scoped.size()]);
    }

    public static boolean hasIncludeEntryFor(List includes, String elementpath) {
        if (includes == null || elementpath == null) {
            return false;
        }
        String entry = null;
        String path = null;
        int i = 0;
        while (i < includes.size()) {
            entry = (String)includes.get(i);
            path = entry.substring(1);
            if (elementpath.equals(path) || path.indexOf(elementpath) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final IncludeEntry[] findIncludeEntries(List includes, String elementpath) {
        if (includes == null || elementpath == null) {
            return NO_ENTRIES;
        }
        String entry = null;
        String path = null;
        ArrayList<IncludeEntry> list = new ArrayList<IncludeEntry>();
        int i = 0;
        while (i < includes.size()) {
            entry = (String)includes.get(i);
            path = entry.substring(1);
            if (elementpath.equals(path) || path.indexOf(elementpath) > -1) {
                try {
                    list.add(new IncludeEntry(Integer.parseInt(entry.substring(0, 1)), path));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i;
        }
        return list.toArray(new IncludeEntry[list.size()]);
    }

    public static final IncludeEntry[] getIncludeEntries(ILaunchConfiguration configuration) {
        block5: {
            try {
                List includes = configuration.getAttribute("includepath", null);
                if (includes == null) break block5;
                ArrayList<IncludeEntry> entries = new ArrayList<IncludeEntry>(includes.size());
                String entry = null;
                int i = 0;
                while (i < includes.size()) {
                    entry = (String)includes.get(i);
                    try {
                        entries.add(new IncludeEntry(Integer.parseInt(entry.substring(0, 1)), entry.substring(1)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++i;
                }
                return entries.toArray(new IncludeEntry[entries.size()]);
            }
            catch (CoreException coreException) {}
        }
        return NO_ENTRIES;
    }
}

