/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationInspectorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testAddComplexAnnotationQNValue() throws JavaModelException, AnnotationGeneratorException {
        IValue qv = AnnotationFactory.createQualifiedNameValue((String)"full.qualified.Name");
        IParamValuePair pv = AnnotationFactory.createParamValuePairValue((String)"param", (IValue)qv);
        HashSet<IParamValuePair> paramValues = new HashSet<IParamValuePair>();
        paramValues.add(pv);
        IAnnotation annotation = AnnotationFactory.createAnnotation((String)"javax.jws.WebService", paramValues, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(annotation, (IJavaElement)this.endpoint);
        AnnotationsTest.assertTrue((AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType().size() > 0 ? 1 : 0) != 0);
    }

    public void testAddComplexClassAnnotation() throws JavaModelException, AnnotationGeneratorException {
        HashSet<IParamValuePair> paramValues = new HashSet<IParamValuePair>();
        this.addStringProperty(paramValues, "serviceName", "serviceName");
        this.addStringProperty(paramValues, "name", "portTypeName");
        this.addStringProperty(paramValues, "targetNamespace", "http://demo.sap.com/");
        this.addStringProperty(paramValues, "wsdlLocation", "http://wsdl/url/");
        this.addStringProperty(paramValues, "portName", "portName");
        this.addStringProperty(paramValues, "endpointInterface", "org.eclipse.demo.ISei");
        IAnnotation annotation = AnnotationFactory.createAnnotation((String)"javax.jws.WebService", paramValues, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(annotation, (IJavaElement)this.endpoint);
        AnnotationInspectorImpl annotationInspector = new AnnotationInspectorImpl(this.endpoint);
        Collection typeAnnotations = annotationInspector.inspectType();
        boolean result = false;
        for (IAnnotation typeAnnotation : typeAnnotations) {
            if (!typeAnnotation.getAnnotationName().equals("WebService") && !typeAnnotation.getAnnotationName().equals("javax.jws.WebService")) continue;
            if (typeAnnotation.getParamValuePairs().size() != 6 || !typeAnnotation.getPropertyValue("serviceName").equals("serviceName") || !typeAnnotation.getPropertyValue("name").equals("portTypeName") || !typeAnnotation.getPropertyValue("targetNamespace").equals("http://demo.sap.com/") || !typeAnnotation.getPropertyValue("wsdlLocation").equals("http://wsdl/url/") || !typeAnnotation.getPropertyValue("portName").equals("portName") || !typeAnnotation.getPropertyValue("endpointInterface").equals("org.eclipse.demo.ISei")) break;
            result = true;
        }
        AnnotationsTest.assertTrue((String)"Class is not annotated correctly", (boolean)result);
    }

    public void testAddComplexMethodAnnotation() throws JavaModelException, AnnotationGeneratorException {
        HashSet<IParamValuePair> paramValues = new HashSet<IParamValuePair>();
        IValue emValue = AnnotationFactory.createBooleanValue((boolean)false);
        paramValues.add(AnnotationFactory.createParamValuePairValue((String)"exclude", (IValue)emValue));
        this.addStringProperty(paramValues, "operationName", "annotatedMethod");
        this.addStringProperty(paramValues, "action", "go");
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        IAnnotation annotation = AnnotationFactory.createAnnotation((String)"javax.jws.WebMethod", paramValues, (IJavaElement)method);
        AnnotationWriter.getInstance().setAppliedElement(annotation, (IJavaElement)method);
        AnnotationInspectorImpl annotationInspector = new AnnotationInspectorImpl(this.endpoint);
        Collection methodAnnotations = annotationInspector.inspectMethod(method);
        boolean result = false;
        for (IAnnotation methodAnnotation : methodAnnotations) {
            if (!methodAnnotation.getAnnotationName().equals("javax.jws.WebMethod") && !methodAnnotation.getAnnotationName().equals("WebMethod")) continue;
            if (methodAnnotation.getParamValuePairs().size() != 3 || !methodAnnotation.getPropertyValue("exclude").equals("false") || !methodAnnotation.getPropertyValue("operationName").equals("annotatedMethod") || !methodAnnotation.getPropertyValue("action").equals("go")) break;
            result = true;
        }
        AnnotationsTest.assertTrue((String)"Method is not annotated correctly", (boolean)result);
    }

    public void testAddComplexParamAnnotation() throws JavaModelException, AnnotationGeneratorException {
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        ITypeParameter typeParameter = method.getTypeParameter("annotatedParam");
        HashSet<IParamValuePair> paramValues = new HashSet<IParamValuePair>();
        this.addStringProperty(paramValues, "annotatedParam", "param");
        this.addStringProperty(paramValues, "targetNamespace", "http://demo.sap.com/params/");
        this.addStringProperty(paramValues, "partName", "partName");
        IAnnotation annotation = AnnotationFactory.createAnnotation((String)"javax.jws.WebParam", paramValues, (IJavaElement)typeParameter);
        AnnotationWriter.getInstance().setAppliedElement(annotation, (IJavaElement)typeParameter);
    }

    private void addStringProperty(Set<IParamValuePair> paramValues, String property, String value) {
        IValue pValue = AnnotationFactory.createStringValue((String)value);
        IParamValuePair pair = AnnotationFactory.createParamValuePairValue((String)property, (IValue)pValue);
        paramValues.add(pair);
    }
}

