/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class DataTableResolutionTestCase
extends SingleJSPTestCase {
    public DataTableResolutionTestCase() {
        super("/testdata/jsps/dataTableResolution.jsp.data", "/dataTableResolution.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    public void testSanity() {
        DataTableResolutionTestCase.assertEquals((String)"foo.x", (String)ELAssert.getELText(this._structuredDocument, 879));
        DataTableResolutionTestCase.assertEquals((String)"row1.name", (String)ELAssert.getELText(this._structuredDocument, 1036));
        DataTableResolutionTestCase.assertEquals((String)"row3.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1188));
        DataTableResolutionTestCase.assertEquals((String)"row4.anyField", (String)ELAssert.getELText(this._structuredDocument, 1363));
        DataTableResolutionTestCase.assertEquals((String)"row2WrongVar.x", (String)ELAssert.getELText(this._structuredDocument, 1554));
        DataTableResolutionTestCase.assertEquals((String)"row2.wrongMember", (String)ELAssert.getELText(this._structuredDocument, 1687));
    }

    public void testNoErrorExprs() {
        this.assertNoError(879, "Ljava.lang.Object;");
        this.assertNoError(1036, "Ljava.lang.String;");
        this.assertNoError(1188, "Ljava.lang.String;");
        this.assertNoError(1363, "Ljava.lang.Object;");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> problems = this.assertSemanticInfo(1554, null, 1);
        ELAssert.assertContainsProblem(problems, 20);
        problems = this.assertSemanticWarning(1687, null, 1);
        ELAssert.assertContainsProblem(problems, 19);
    }

    public void testErrorExprs() {
    }
}

