/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import org.eclipse.jst.jsf.taglibprocessing.attributevalues.IntegerType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;

public class LengthType
extends IntegerType {
    private static final String INVALID_LENGTH = Messages.LengthType_invalid_integer;

    public boolean isValidValue(String value) {
        if (value == null) {
            return true;
        }
        String aValue = this.stripPercentIfPresent(value);
        try {
            int anInt = Integer.valueOf(aValue);
            if (anInt < 0) {
                this.addNewValidationMessage(INVALID_LENGTH);
            }
            return this.getValidationMessages().isEmpty();
        }
        catch (NumberFormatException numberFormatException) {
            this.addNewValidationMessage(INVALID_LENGTH);
            return false;
        }
    }

    private String stripPercentIfPresent(String value) {
        if (value.length() > 0 && value.lastIndexOf(37) == value.length() - 1) {
            return value.replaceFirst("%", "");
        }
        return value;
    }
}

