/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataTableDeleteColumnHeaderCommand
extends DesignerCommand {
    boolean _header;
    private Element _dataTable;

    public DataTableDeleteColumnHeaderCommand(IHTMLGraphicalViewer viewer, Element dataTable, boolean header) {
        super(header ? CommandResources.getString("DataTableDeleteColumnHeaderCommand.Label.DeleteColumnHeader") : CommandResources.getString("DataTableDeleteColumnHeaderCommand.Label.DeleteColumnFooter"), viewer);
        this._header = header;
        this._dataTable = dataTable;
    }

    public boolean canExecute() {
        int num = 0;
        NodeList children = this._dataTable.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Element column;
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node) && this.hasHeader(column = (Element)node)) {
                ++num;
                break;
            }
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        NodeList children = this._dataTable.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Element column;
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node) && this.hasHeader(column = (Element)node)) {
                Element hf = JSFDOMUtil.findFacet(column, this._header ? "header" : "footer");
                column.removeChild(hf);
            }
            ++i;
        }
        this.formatNode(this._dataTable);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }

    private boolean hasHeader(Element column) {
        return JSFDOMUtil.findFacet(column, this._header ? "header" : "footer") != null;
    }
}

