/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DeleteNodeCommand;
import org.eclipse.jst.pagedesigner.commands.DesignAction;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.commands.range.DeleteCommand;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;

public class DeleteAction
extends DesignAction {
    public DeleteAction(GraphicalEditor editor) {
        super(editor, CommandResources.getString("DeleteAction.CommandLabel.Delete"));
    }

    public void perform() {
        DesignerCommand command = null;
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer.isInRangeMode()) {
            command = new DeleteCommand(true, viewer);
            command.execute();
        } else {
            command = new DeleteNodeCommand(viewer);
            command.execute();
        }
    }

    public boolean isEnabled() {
        IHTMLGraphicalViewer viewer = this.getViewer();
        if (viewer != null) {
            if (viewer.isInRangeMode() && !EditModelQuery.isSame(viewer.getRangeSelection())) {
                return true;
            }
            if (!viewer.isInRangeMode()) {
                int size = viewer.getSelectedEditParts().size();
                if (size > 1) {
                    return true;
                }
                if (size == 1 && !(viewer.getSelectedEditParts().get(0) instanceof DocumentEditPart)) {
                    return true;
                }
            }
        }
        return false;
    }
}

