/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import java.util.Stack;
import java.util.Vector;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.range.DesignEdit;
import org.eclipse.jst.pagedesigner.commands.range.WorkNode;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IETablePositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingNavigationMediator;
import org.eclipse.jst.pagedesigner.viewer.LayoutPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DeleteEdit
extends DesignEdit {
    private static final Logger _log = PDPlugin.getLogger(DeleteEdit.class);
    private static final boolean INNER_DEBUG = false;
    private boolean _forward;
    Vector deleted = new Vector();

    public DeleteEdit(DOMRange range, GraphicalViewer viewer, boolean forward) {
        super(range, viewer);
        this._forward = forward;
    }

    public DeleteEdit(DOMRange range, GraphicalViewer viewer) {
        super(range, viewer);
    }

    protected boolean operate() {
        try {
            boolean result = true;
            if (EditModelQuery.isSame(this.getRange())) {
                this.deleteSingle();
            } else {
                this.deleteRange();
            }
            return result;
        }
        catch (Exception e) {
            _log.error("Exception", (Throwable)e);
            return false;
        }
    }

    private void deleteSingle() {
        IDOMPosition opPosition = this.getOperationPosition();
        opPosition = EditHelper.moveToNextEditPosition(this.getOperationPosition(), this._forward, new InlineEditingNavigationMediator(new ActionData(5, null)));
        if (EditModelQuery.isSame(opPosition, this.getOperationPosition())) {
            return;
        }
        this.setRange(new DOMRange(opPosition, this.getOperationPosition()));
        this.deleteRange();
    }

    protected Stack deleteRange() {
        WorkNode root = this.getRootWorkNode();
        Node rootNode = root.getNode();
        Stack result = this.getProcessedResult();
        this.collectOtherStyles(rootNode, result);
        return result;
    }

    private boolean isTableComponents(WorkNode node) {
        String name = node.getNode().getNodeName();
        return "td".equalsIgnoreCase(name) || "th".equalsIgnoreCase(name) || "tr".equalsIgnoreCase(name) || "thead".equalsIgnoreCase(name) || "tbody".equalsIgnoreCase(name) || "tfoot".equalsIgnoreCase(name);
    }

    private Node processContainerTable(WorkNode node) {
        Node result = null;
        if ((this.isTableComponents(node) || "table".equalsIgnoreCase(node.getNode().getNodeName())) && new IETablePositionRule(null).isInValidTable(node.getNode())) {
            result = node.getNode().cloneNode(false);
        }
        return result;
    }

    private Node processContainerStyleNodes(WorkNode node) {
        String name = node.getNode().getNodeName();
        Node result = null;
        if (("li".equalsIgnoreCase(name) || EditModelQuery.HTML_STYLE_NODES.contains(node.getNode().getLocalName())) && node.getNode().hasChildNodes()) {
            result = node.getNode().cloneNode(false);
        }
        return result;
    }

    private Node processContainerView(WorkNode node) {
        Element result = null;
        if ("view".equalsIgnoreCase(node.getNode().getLocalName())) {
            result = EditModelQuery.getDocumentNode(node.getNode()).createElement("subview");
            result.setPrefix(node.getNode().getPrefix());
        } else if ("body".equalsIgnoreCase(node.getNode().getNodeName()) || "html".equalsIgnoreCase(node.getNode().getNodeName())) {
            result = EditModelQuery.getDocumentNode(node.getNode()).createElement(node.getNode().getNodeName());
        }
        return result;
    }

    protected Node processContainer(WorkNode node) {
        Node result = this.processContainerView(node);
        if (result == null) {
            result = this.processContainerTable(node);
        }
        if (result == null) {
            result = this.processContainerStyleNodes(node);
        }
        if (result == null) {
            if (LayoutPart.getConcreteNode(node.getNode()) != null) {
                Node parent = node.getNode().getParentNode();
                Node refNode = node.getNode();
                Node child = node.getNode().getFirstChild();
                Node first = null;
                Node last = null;
                int index = 0;
                NodeList children = node.getNode().getChildNodes();
                int size = children.getLength();
                while (child != null) {
                    Node next = child.getNextSibling();
                    Node n = EditHelper.deleteNode(child);
                    parent.insertBefore(n, refNode);
                    if (index == 0) {
                        first = refNode != null ? refNode.getPreviousSibling() : parent.getLastChild();
                    }
                    if (index == size - 1) {
                        last = refNode != null ? refNode.getPreviousSibling() : parent.getLastChild();
                    }
                    ++index;
                    child = next;
                }
                if (node.getPosOffsets()[0] <= 0) {
                    this.setOperationPosition(new DOMRefPosition(first, false));
                } else {
                    this.setOperationPosition(new DOMRefPosition(last, true));
                }
            } else {
                this.setOperationPosition(new DOMRefPosition(node.getNode(), false));
            }
            result = EditHelper.deleteNode(node.getNode());
        }
        return result;
    }

    protected Node processNode(WorkNode node) {
        Node result = null;
        if (!this.isTableComponents(node) || !new IETablePositionRule(null).isInValidTable(node.getNode())) {
            this.setOperationPosition(new DOMRefPosition(node.getNode(), false));
            result = EditHelper.deleteNode(node.getNode());
        }
        return result;
    }

    protected Text processText(WorkNode node) {
        Text currentNode = (Text)node.getNode();
        int[] offsets = node.getPosOffsets();
        Node second = null;
        int location1 = EditHelper.getInstance().getLocation(currentNode, node.getPosOffsets()[0], true);
        int location2 = EditHelper.getInstance().getLocation(currentNode, node.getPosOffsets()[1], true);
        if (currentNode.getData().length() > 0) {
            IDOMPosition position;
            if (location1 == 3) {
                position = new DOMPosition(currentNode, node.getPosOffsets()[0]);
                this.setOperationPosition(position);
                position = DOMPositionHelper.splitText(position);
                Node nnode = position.getNextSiblingNode();
                if (nnode instanceof Text) {
                    currentNode = (Text)nnode;
                    offsets[1] = offsets[1] - (offsets[0] > 0 ? offsets[0] : 0);
                }
            } else if (currentNode.getPreviousSibling() != null) {
                this.setOperationPosition(new DOMRefPosition(currentNode.getPreviousSibling(), true));
            } else {
                this.setOperationPosition(new DOMPosition(currentNode.getParentNode(), 0));
            }
            if (location2 >= 3) {
                position = new DOMPosition(currentNode, offsets[1]);
                position = DOMPositionHelper.splitText(position);
                second = position.getPreviousSiblingNode();
            }
            return second != null ? (Text)EditHelper.deleteNode(second) : null;
        }
        this.setOperationPosition(new DOMRefPosition(currentNode, false));
        return (Text)EditHelper.deleteNode(currentNode);
    }
}

