/*******************************************************************************
 * Copyright (c) 2008, 2014 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.server.preview.internal;

import org.eclipse.jetty.util.log.Logger;

public class WTPLogger implements Logger {
	protected boolean debug = false;
	protected boolean warn = false;
	protected boolean info = false;	
	protected boolean ignore = false;	

	public void debug(Throwable t) {
		debug(null, t);
  }

	public void debug(String msg, Throwable t) {
		if (debug) {
			if (msg != null) {
				System.out.println(msg);
			}
			t.printStackTrace();
		}
	}

	public void debug(String msg, Object... args) {
	  if (debug) {
			System.out.println(msg);
	  }
  }

	public String getName() {
	  // TODO Auto-generated method stub
	  return "org.eclipse.wst.server.preview.internal.WTPLogger";
  }

	public Logger getLogger(String name) {
		return this;
	}

	public void info(Throwable t) {
	  info("", t);
  }

	public void info(String msg, Throwable t) {
		if (info) {
			if (msg != null) {
				System.out.println(msg);
			}
			t.printStackTrace();
		}
  }

	public void info(String msg, Object... args) {
		if (debug) {
			System.out.println(msg);
		}
  }

	public boolean isDebugEnabled() {
		return debug;
	}

	public void setDebugEnabled(boolean debug) {
		this.debug = debug;
	}

	public boolean isWarn() {
  	return warn;
  }

	public void setWarn(boolean warn) {
  	this.warn = warn;
  }

	public boolean isInfo() {
  	return info;
  }

	public void setInfo(boolean info) {
  	this.info = info;
  }
	
	public boolean isIgnore() {
  	return ignore;
  }

	public void setIgnore(boolean ignore) {
  	this.ignore = ignore;
  }
	
	public void warn(String msg, Throwable t) {
		if (warn) {
			System.out.println(msg);
			t.printStackTrace();
		}
	}

	public void warn(String msg, Object... args) {
		if (warn) {
			System.out.println(msg);
		}
  }

	public void warn(Throwable t) {
	  warn(null, t);
  }

	public void ignore(Throwable msg) {
    if (ignore) {
			System.out.println(msg);
    }
  }

	public void debug(String msg, long value) {
		  if (debug) {
				System.out.println(msg);
		  }
	}

}
