/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class FnBoolean
extends Function {
    public FnBoolean() {
        super(new QName("boolean"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return ResultSequenceFactory.create_new(FnBoolean.fn_boolean(argument));
    }

    public static XSBoolean fn_boolean(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return XSBoolean.FALSE;
        }
        Item at = arg.item(0);
        if (at instanceof CalendarType) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof NodeType) {
            return XSBoolean.TRUE;
        }
        if (arg.size() > 1) {
            throw DynamicError.throw_type_error();
        }
        if (!(at instanceof AnyAtomicType)) {
            return XSBoolean.TRUE;
        }
        if (at instanceof XSBoolean && !((XSBoolean)at).value()) {
            return XSBoolean.FALSE;
        }
        if ((at instanceof XSString || at instanceof XSUntypedAtomic) && ((AnyType)at).getStringValue().equals("")) {
            return XSBoolean.FALSE;
        }
        if (at instanceof NumericType && ((NumericType)at).zero()) {
            return XSBoolean.FALSE;
        }
        if (at instanceof XSFloat && ((XSFloat)at).nan()) {
            return XSBoolean.FALSE;
        }
        if (at instanceof XSDouble && ((XSDouble)at).nan()) {
            return XSBoolean.FALSE;
        }
        return XSBoolean.TRUE;
    }
}

