/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.context;

import java.util.Collection;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;

public interface Accessor
extends JaxbContextNode {
    public JavaResourceAttribute getJavaResourceAttribute();

    public boolean isFor(JavaResourceField var1);

    public boolean isFor(JavaResourceMethod var1, JavaResourceMethod var2);

    public String getJavaResourceAttributeBaseTypeName();

    public boolean isJavaResourceAttributeCollectionType();

    public boolean isJavaResourceAttributeTypeSubTypeOf(String var1);

    public static final class AccessorTools {
        public static final String BYTE_ARRAY_CLASS_NAME = "byte[]";
        public static final String COLLECTION_CLASS_NAME = Collection.class.getName();
        public static final String OBJECT_CLASS_NAME = Object.class.getName();

        public static String getBaseTypeName(JavaResourceAttribute attribute) {
            TypeBinding typeBinding = attribute.getTypeBinding();
            if (typeBinding.isArray()) {
                if (BYTE_ARRAY_CLASS_NAME.equals(typeBinding.getQualifiedName())) {
                    return BYTE_ARRAY_CLASS_NAME;
                }
                if (typeBinding.getArrayDimensionality() == 1) {
                    return typeBinding.getArrayComponentTypeName();
                }
            } else if (typeBinding.isSubTypeOf(COLLECTION_CLASS_NAME)) {
                if (typeBinding.getTypeArgumentNamesSize() == 1) {
                    return typeBinding.getTypeArgumentName(0);
                }
                return OBJECT_CLASS_NAME;
            }
            return typeBinding.getQualifiedName();
        }

        public static boolean isCollectionType(JavaResourceAttribute attribute) {
            TypeBinding typeBinding = attribute.getTypeBinding();
            if (typeBinding.isArray()) {
                return typeBinding.getArrayDimensionality() == 1 && !BYTE_ARRAY_CLASS_NAME.equals(typeBinding.getQualifiedName());
            }
            return typeBinding.isSubTypeOf(COLLECTION_CLASS_NAME);
        }
    }
}

