/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

public class NameMatcher {
    public static boolean isSimilarName(String name1, String name2) {
        return NameMatcher.getSimilarity(name1, name2) >= 0;
    }

    public static int getSimilarity(String name1, String name2) {
        if (name1.length() > name2.length()) {
            String tmp = name1;
            name1 = name2;
            name2 = tmp;
        }
        int name1len = name1.length();
        int name2len = name2.length();
        int nMatched = 0;
        int i = 0;
        while (i < name1len && NameMatcher.isSimilarChar(name1.charAt(i), name2.charAt(i))) {
            ++i;
            ++nMatched;
        }
        int k = name1len;
        int diff = name2len - name1len;
        while (k > i && NameMatcher.isSimilarChar(name1.charAt(k - 1), name2.charAt(k + diff - 1))) {
            --k;
            ++nMatched;
        }
        if (nMatched == name2len) {
            return 200;
        }
        if (name2len - nMatched > nMatched) {
            return -1;
        }
        int tolerance = name2len / 4 + 1;
        return (tolerance - (k - i)) * 256 / tolerance;
    }

    private static boolean isSimilarChar(char ch1, char ch2) {
        return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
    }
}

