/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEventFactory;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeTester<EVENTTYPE, CHANGETYPE> {
    protected final List<EVENTTYPE> _events = new ArrayList<EVENTTYPE>();
    private final IWorkspaceContextWithEvents _context;
    private final MockResourceChangeEventFactory _eventFactory;
    private final IFolder _resourceRoot;

    public ChangeTester(IWorkspaceContextWithEvents context, MockResourceChangeEventFactory factory, IFolder resourceRoot) {
        this._context = context;
        this._eventFactory = factory;
        this._resourceRoot = resourceRoot;
    }

    public void fireResourceFileContentsChange(String resourceId) {
        this.installListener();
        IFile file = this.getFile(resourceId);
        IResourceChangeEvent event = this._eventFactory.createSimpleFileChange(file, true);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public void fireResourceFileAdd(String resourceId) {
        this.installListener();
        IFile file = this._resourceRoot.getFile(resourceId);
        IResourceChangeEvent event = this._eventFactory.createSimpleFileAdded(file);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    private IFile getFile(String resourceId) {
        IFile file = this._resourceRoot.getFile(resourceId);
        Assert.assertNotNull((Object)file);
        return file;
    }

    private IFolder getFolder(String folderName) {
        IFolder folder = this._resourceRoot.getFolder(folderName);
        Assert.assertNotNull((Object)folder);
        return folder;
    }

    protected abstract void installListener();

    protected abstract boolean isChangeType(EVENTTYPE var1, CHANGETYPE var2);

    public void fireResourceFileDelete(String resourceId) {
        this.installListener();
        IFile file = this.getFile(resourceId);
        IResourceChangeEvent event = this._eventFactory.createSimpleFileRemove(file);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public void fireResourceFolderAdd(String folderName) {
        this.installListener();
        IFolder folder = this.getFolder(folderName);
        IResourceChangeEvent event = this._eventFactory.createSimpleFolderAdded(folder);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public void fireResourceFolderDelete(String folderName) {
        this.installListener();
        IFolder folder = this.getFolder(folderName);
        IResourceChangeEvent event = this._eventFactory.createSimpleFolderDeleted(folder);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public void fireResourceFileDeleteRecusive(String folderName) {
        this.installListener();
        IFolder folder = this.getFolder(folderName);
        IResourceChangeEvent event = this._eventFactory.createRecursiveFolderDeleted(folder);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    protected abstract void removeListener();

    public void fireResourceFolderRename(String folderName, String newFolderName) {
        this.installListener();
        IFolder folder = this.getFolder(folderName);
        IFolder newFolder = this.getFolder(newFolderName);
        IResourceChangeEvent event = this._eventFactory.createSimpleFolderRename(folder, newFolder);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public void fireResourceFileRename(String fileName, String newFileName) {
        this.installListener();
        IFile folder = this.getFile(fileName);
        IFile newFolder = this.getFile(newFileName);
        IResourceChangeEvent event = this._eventFactory.createSimpleFileRename(folder, newFolder);
        this._context.fireWorkspaceEvent(event);
        this.removeListener();
    }

    public EVENTTYPE getEvent(int eventNum) {
        return this._events.get(eventNum);
    }

    public EVENTTYPE getSingleEvent(CHANGETYPE type) {
        List<EVENTTYPE> events = this.getEvent(type);
        if (events.isEmpty()) {
            throw new AssertionError();
        }
        if (events.size() > 1) {
            throw new AssertionError();
        }
        return events.get(0);
    }

    public List<EVENTTYPE> getEvent(CHANGETYPE type) {
        ArrayList<EVENTTYPE> foundEvents = new ArrayList<EVENTTYPE>();
        for (EVENTTYPE event : this._events) {
            if (!this.isChangeType(event, type)) continue;
            foundEvents.add(event);
        }
        return foundEvents;
    }

    public void assertNumEvents(int numEvents) {
        junit.framework.Assert.assertEquals((int)numEvents, (int)this._events.size());
    }
}

