/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.transport.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.geronimo.javamail.authentication.ClientAuthenticator;
import org.apache.geronimo.javamail.authentication.CramMD5Authenticator;
import org.apache.geronimo.javamail.authentication.DigestMD5Authenticator;
import org.apache.geronimo.javamail.authentication.LoginAuthenticator;
import org.apache.geronimo.javamail.authentication.PlainAuthenticator;
import org.apache.geronimo.javamail.transport.nntp.NNTPReply;
import org.apache.geronimo.javamail.util.MIMEOutputStream;
import org.apache.geronimo.javamail.util.TraceInputStream;
import org.apache.geronimo.javamail.util.TraceOutputStream;
import org.apache.geronimo.mail.util.Base64;
import org.apache.geronimo.mail.util.SessionUtil;

public class NNTPConnection {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected static final String MAIL_NNTP_AUTH = "auth";
    protected static final String MAIL_NNTP_PORT = "port";
    protected static final String MAIL_NNTP_TIMEOUT = "timeout";
    protected static final String MAIL_NNTP_SASL_REALM = "sasl.realm";
    protected static final String MAIL_NNTP_FACTORY_CLASS = "socketFactory.class";
    protected static final String MAIL_NNTP_FACTORY_FALLBACK = "fallback";
    protected static final String MAIL_NNTP_LOCALADDRESS = "localaddress";
    protected static final String MAIL_NNTP_LOCALPORT = "localport";
    protected static final String MAIL_NNTP_QUITWAIT = "quitwait";
    protected static final String MAIL_NNTP_FACTORY_PORT = "socketFactory.port";
    protected static final String MAIL_NNTP_ENCODE_TRACE = "encodetrace";
    protected static final int MIN_MILLIS = 60000;
    protected static final int TIMEOUT = 300000;
    protected static final String DEFAULT_MAIL_HOST = "localhost";
    protected static final int DEFAULT_NNTP_PORT = 119;
    protected static final String AUTHENTICATION_PLAIN = "PLAIN";
    protected static final String AUTHENTICATION_LOGIN = "LOGIN";
    protected static final String AUTHENTICATION_CRAMMD5 = "CRAM-MD5";
    protected static final String AUTHENTICATION_DIGESTMD5 = "DIGEST-MD5";
    String protocol;
    protected String host;
    protected int port;
    protected Socket socket;
    protected InputStream inputStream;
    protected BufferedReader in;
    protected OutputStream outputStream;
    protected boolean postingAllowed = true;
    protected String username;
    protected String password;
    protected String realm;
    protected NNTPReply lastServerResponse = null;
    protected Session session;
    protected PrintStream debugStream;
    protected boolean debug;
    protected HashMap serverAuthenticationMechanisms;
    protected HashMap serverExtensionArgs;
    protected String welcomeString = null;

    public NNTPConnection(String protocol, Session session, String host, int port, String username, String password, boolean debug) {
        this.protocol = protocol;
        this.session = session;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.debug = debug;
        this.debugStream = session.getDebugOut();
    }

    public void connect() throws MessagingException {
        try {
            this.getConnection();
            this.getWelcome();
        }
        catch (IOException e) {
            if (this.debug) {
                this.debugOut("I/O exception establishing connection", e);
            }
            throw new MessagingException("Connection error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        if (this.socket == null) {
            return;
        }
        try {
            this.sendQuit();
        }
        finally {
            this.closeServerConnection();
        }
    }

    protected void getConnection() throws IOException {
        if (this.socket == null) {
            this.getConnectedSocket();
        } else {
            this.port = this.socket.getPort();
            this.host = this.socket.getInetAddress().getHostName();
        }
        this.inputStream = new TraceInputStream(this.socket.getInputStream(), this.debugStream, this.debug, this.getBooleanProperty(MAIL_NNTP_ENCODE_TRACE, false));
        this.outputStream = new TraceOutputStream(this.socket.getOutputStream(), this.debugStream, this.debug, this.getBooleanProperty(MAIL_NNTP_ENCODE_TRACE, false));
        this.in = new BufferedReader(new InputStreamReader(this.inputStream));
    }

    public void closeServerConnection() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.in = null;
    }

    public void getConnectedSocket() throws IOException {
        if (this.debug) {
            this.debugOut("Attempting plain socket connection to server " + this.host + ":" + this.port);
        }
        String socketFactory = this.getProperty(MAIL_NNTP_FACTORY_CLASS);
        int timeout = this.getIntProperty(MAIL_NNTP_TIMEOUT, -1);
        InetAddress localAddress = null;
        String localAddrProp = this.getProperty(MAIL_NNTP_LOCALADDRESS);
        if (localAddrProp != null) {
            localAddress = InetAddress.getByName(localAddrProp);
        }
        int localPort = this.getIntProperty(MAIL_NNTP_LOCALPORT, 0);
        this.socket = null;
        if (socketFactory == null) {
            this.socket = new Socket(this.host, this.port, localAddress, localPort);
        } else {
            try {
                int socketFactoryPort = this.getIntProperty(MAIL_NNTP_FACTORY_PORT, -1);
                Integer portArg = new Integer(socketFactoryPort == -1 ? this.port : socketFactoryPort);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(socketFactory);
                Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                Object defFactory = getDefault.invoke(new Object(), new Object[0]);
                if (localAddress != null) {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE, InetAddress.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg, localAddress, new Integer(localPort)};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                } else {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                }
            }
            catch (Throwable e) {
                if (this.getBooleanProperty(MAIL_NNTP_FACTORY_FALLBACK, false)) {
                    if (this.debug) {
                        this.debugOut("First plain socket attempt faile, falling back to default factory", e);
                    }
                    this.socket = new Socket(this.host, this.port, localAddress, localPort);
                }
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (this.debug) {
                    this.debugOut("Plain socket creation failure", e);
                }
                IOException ioe = new IOException("Error connecting to " + this.host + ", " + this.port);
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public void getWelcome() throws MessagingException {
        NNTPReply line = this.getReply();
        if (line.isError()) {
            throw new MessagingException("Error connecting to news server: " + line.getMessage());
        }
        this.postingAllowed = line.getCode() == 200;
        this.welcomeString = line.getMessage();
        this.getExtensions();
    }

    public void sendQuit() throws MessagingException {
        if (this.getBooleanProperty(MAIL_NNTP_QUITWAIT, false)) {
            this.sendLine("QUIT");
        } else {
            this.sendCommand("QUIT");
        }
    }

    public NNTPReply selectGroup(String name) throws MessagingException {
        return this.sendCommand("GROUP " + name);
    }

    protected void getExtensions() throws MessagingException {
        NNTPReply reply = this.sendCommand("LIST EXTENSIONS", 202);
        if (reply.getCode() != 202) {
            return;
        }
        this.serverExtensionArgs = new HashMap();
        this.serverAuthenticationMechanisms = new HashMap();
        List extensions = reply.getData();
        for (int i = 0; i < extensions.size(); ++i) {
            this.processExtension((String)extensions.get(i));
        }
    }

    protected void processExtension(String extension) {
        String extensionName = extension.toUpperCase();
        String argument = "";
        int delimiter = extension.indexOf(32);
        if (delimiter != -1) {
            extensionName = extension.substring(0, delimiter).toUpperCase();
            argument = extension.substring(delimiter + 1);
        }
        this.serverExtensionArgs.put(extensionName, argument);
        if (extensionName.equals("AUTHINFO")) {
            this.serverAuthenticationMechanisms.put("AUTHINFO", "AUTHINFO");
        } else if (extensionName.equals("SASL")) {
            StringTokenizer tokenizer = new StringTokenizer(argument);
            while (tokenizer.hasMoreTokens()) {
                String mechanism = tokenizer.nextToken().toUpperCase();
                this.serverAuthenticationMechanisms.put(mechanism, mechanism);
            }
        }
    }

    public String extensionParameter(String name) {
        if (this.serverExtensionArgs != null) {
            return (String)this.serverExtensionArgs.get(name);
        }
        return null;
    }

    public boolean supportsExtension(String name) {
        return this.extensionParameter(name) != null;
    }

    protected boolean supportsAuthentication(String mechanism) {
        return this.serverAuthenticationMechanisms.get(mechanism) != null;
    }

    public synchronized void sendPost(Message msg) throws MessagingException {
        NNTPReply line = this.sendCommand("POST");
        if (line.getCode() != 340) {
            throw new MessagingException("Server rejected POST command: " + line);
        }
        try {
            MIMEOutputStream mimeOut = new MIMEOutputStream(this.outputStream);
            msg.writeTo(mimeOut);
            mimeOut.flush();
        }
        catch (IOException e) {
            throw new MessagingException("I/O error posting message", e);
        }
        catch (MessagingException e) {
            throw new MessagingException("Exception posting message", e);
        }
        this.sendLine("");
        this.sendLine(".");
        line = new NNTPReply(this.receiveLine());
        if (line.getCode() != 240) {
            throw new MessagingException("Server rejected POST command: " + line);
        }
    }

    public synchronized NNTPReply sendCommand(String command, int success) throws MessagingException {
        NNTPReply reply = this.sendCommand(command);
        if (reply.getCode() == success) {
            reply.retrieveData(this.in);
        }
        return reply;
    }

    public NNTPReply sendCommand(String data) throws MessagingException {
        this.sendLine(data);
        NNTPReply reply = this.getReply();
        if (reply.getCode() == 480 || reply.getCode() == 450) {
            if (this.debug) {
                this.debugOut("Authentication required received from server.");
            }
            this.processAuthentication(reply.getCode());
            this.sendLine(data);
            reply = this.getReply();
        }
        return reply;
    }

    public NNTPReply sendAuthCommand(String data) throws MessagingException {
        this.sendLine(data);
        return this.getReply();
    }

    public void sendLine(String data) throws MessagingException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new MessagingException("no connection");
        }
        try {
            this.outputStream.write(data.getBytes());
            this.outputStream.write(13);
            this.outputStream.write(10);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new MessagingException(e.toString());
        }
    }

    public NNTPReply getReply() throws MessagingException {
        this.lastServerResponse = new NNTPReply(this.receiveLine());
        return this.lastServerResponse;
    }

    public String getLastServerResponse() {
        if (this.lastServerResponse == null) {
            return "";
        }
        return this.lastServerResponse.getReply();
    }

    public String receiveLine() throws MessagingException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new MessagingException("no connection");
        }
        try {
            String line = this.in.readLine();
            if (line == null) {
                throw new MessagingException("Unexpected end of stream");
            }
            return line;
        }
        catch (IOException e) {
            throw new MessagingException("Error reading from server", e);
        }
    }

    public String getSASLRealm() {
        if (this.realm == null) {
            this.realm = this.getProperty(MAIL_NNTP_SASL_REALM);
        }
        return this.realm;
    }

    public void setSASLRealm(String name) {
        this.realm = name;
    }

    protected void processAuthentication(int request) throws MessagingException {
        if (this.username == null || this.password == null) {
            throw new MessagingException("Server requires user authentication");
        }
        if (request == 450) {
            this.processAuthinfoSimple();
        } else if (!this.processAuthinfoSasl()) {
            this.processAuthinfoUser();
        }
    }

    protected void processAuthinfoSimple() throws MessagingException {
        NNTPReply reply = this.sendAuthCommand("AUTHINFO SIMPLE");
        if (reply.getCode() != 350) {
            throw new MessagingException("Error authenticating with server using AUTHINFO SIMPLE");
        }
        reply = this.sendAuthCommand(this.username + " " + this.password);
        if (reply.getCode() != 250) {
            throw new MessagingException("Error authenticating with server using AUTHINFO SIMPLE");
        }
    }

    protected boolean processAuthinfoGeneric() throws MessagingException {
        return false;
    }

    protected boolean processAuthinfoSasl() throws MessagingException {
        NNTPReply line;
        StringBuffer command;
        ClientAuthenticator authenticator = null;
        if (this.supportsAuthentication(AUTHENTICATION_DIGESTMD5)) {
            authenticator = new DigestMD5Authenticator(this.host, this.username, this.password, this.getSASLRealm());
        } else if (this.supportsAuthentication(AUTHENTICATION_CRAMMD5)) {
            authenticator = new CramMD5Authenticator(this.username, this.password);
        } else if (this.supportsAuthentication(AUTHENTICATION_LOGIN)) {
            authenticator = new LoginAuthenticator(this.username, this.password);
        } else if (this.supportsAuthentication(AUTHENTICATION_PLAIN)) {
            authenticator = new PlainAuthenticator(this.username, this.password);
        } else {
            return false;
        }
        if (this.debug) {
            this.debugOut("Authenticating for user: " + this.username + " using " + authenticator.getMechanismName());
        }
        if (authenticator.hasInitialResponse()) {
            command = new StringBuffer();
            command.append("AUTHINFO SASL ");
            command.append(authenticator.getMechanismName());
            command.append(" ");
            command.append(new String(Base64.encode(authenticator.evaluateChallenge(null))));
            this.sendLine(command.toString());
        } else {
            command = new StringBuffer();
            command.append("AUTHINFO SASL");
            command.append(authenticator.getMechanismName());
            this.sendLine(command.toString());
        }
        while (true) {
            if ((line = this.getReply()).getCode() == 250 || line.getCode() == 251) {
                if (this.debug) {
                    this.debugOut("Successful SMTP authentication");
                }
                return true;
            }
            if (line.getCode() != 350) break;
            if (authenticator.isComplete()) {
                if (this.debug) {
                    this.debugOut("Extra authentication challenge " + line);
                }
                return false;
            }
            byte[] challenge = Base64.decode(line.getMessage().getBytes());
            this.sendLine(new String(Base64.encode(authenticator.evaluateChallenge(challenge))));
        }
        if (this.debug) {
            this.debugOut("Authentication failure " + line);
        }
        return false;
    }

    protected void processAuthinfoUser() throws MessagingException {
        NNTPReply reply = this.sendAuthCommand("AUTHINFO USER " + this.username);
        if (reply.getCode() == 250) {
            return;
        }
        if (reply.getCode() != 350) {
            throw new MessagingException("Error authenticating with server using AUTHINFO USER: " + reply);
        }
        reply = this.sendAuthCommand("AUTHINFO PASS " + this.password);
        if (reply.getCode() != 250) {
            throw new MessagingException("Error authenticating with server using AUTHINFO SIMPLE");
        }
    }

    protected void debugOut(String message) {
        this.debugStream.println("NNTPTransport DEBUG: " + message);
    }

    protected void debugOut(String message, Throwable e) {
        this.debugOut("Received exception -> " + message);
        this.debugOut("Exception message -> " + e.getMessage());
        e.printStackTrace(this.debugStream);
    }

    public boolean isPostingAllowed() {
        return this.postingAllowed;
    }

    public String getWelcomeString() {
        return this.welcomeString;
    }

    public String getHost() {
        return this.host;
    }

    String getProperty(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.session.getProperty(fullName);
    }

    String getProperty(String name, String defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return SessionUtil.getProperty(this.session, fullName, defaultValue);
    }

    int getIntProperty(String name, int defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return SessionUtil.getIntProperty(this.session, fullName, defaultValue);
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return SessionUtil.getBooleanProperty(this.session, fullName, defaultValue);
    }
}

