/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;

public class ArchiveWrapper {
    private IArchive archive = null;
    private JavaEEQuickPeek jqp = null;
    private ArchiveWrapper cachedParent = null;
    private List<ArchiveWrapper> cachedWebLibs;
    private List<String> cachedDDMappedModuleURIs = null;
    private List<ArchiveWrapper> cachedEARModules;
    private String[] cachedWebContextRoot = null;
    private HashMap<ArchiveWrapper, ArchiveWrapper> cachedEJBClientArchiveWrapper = null;
    private List<ArchiveWrapper> cachedEARUtilitiesAndWebLibs = null;

    public ArchiveWrapper(IArchive archive) {
        this.archive = archive;
        if (archive == null) {
            throw new NullPointerException();
        }
        JavaEEArchiveUtilities jea = JavaEEArchiveUtilities.INSTANCE;
        this.jqp = jea.getJavaEEQuickPeek(archive);
    }

    public JavaEEQuickPeek getJavaEEQuickPeek() {
        return this.jqp;
    }

    public Object getUnderLyingArchive() {
        return this.archive;
    }

    public ArchiveWrapper getParent() {
        if (this.cachedParent != null) {
            return this.cachedParent;
        }
        this.cachedParent = new ArchiveWrapper(this.archive.getArchive());
        return this.cachedParent;
    }

    public IArchive getIArchive() {
        return this.archive;
    }

    public void close() {
        try {
            if (this.archive.isOpen()) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        catch (RuntimeException e) {
            J2EEPlugin.logError(e);
            throw e;
        }
    }

    public IPath getPath() {
        return this.archive.getPath();
    }

    private void fail() {
        throw new RuntimeException("ArchiveWrapper is inconsistent.");
    }

    public int getSize() {
        return this.archive.getArchiveResources().size();
    }

    public List<ArchiveWrapper> getWebLibs() {
        if (this.cachedWebLibs != null) {
            return this.cachedWebLibs;
        }
        if (this.jqp.getType() != 4) {
            this.fail();
        }
        this.cachedWebLibs = new ArrayList<ArchiveWrapper>();
        List resources = this.archive.getArchiveResources();
        for (IArchiveResource resource : resources) {
            String lastSegment;
            IPath path;
            if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 2 || !path.segment(0).equals("WEB-INF") || !path.segment(1).equals("lib") || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip")) continue;
            try {
                IArchive webLib = this.archive.getNestedArchive(resource);
                this.cachedWebLibs.add(new ArchiveWrapper(webLib));
            }
            catch (ArchiveOpenFailureException e) {
                J2EEPlugin.logError(e);
            }
        }
        return this.cachedWebLibs;
    }

    public List<String> getDDMappedModuleURIs() {
        if (this.cachedDDMappedModuleURIs != null) {
            return this.cachedDDMappedModuleURIs;
        }
        if (this.jqp.getType() != 1) {
            this.fail();
        }
        this.cachedDDMappedModuleURIs = new ArrayList<String>();
        if (this.archive.containsArchiveResource((IPath)new Path("META-INF/application.xml"))) {
            if (this.jqp.getJavaEEVersion() == 50 || this.jqp.getJavaEEVersion() == 60 || this.jqp.getJavaEEVersion() == 70 || this.jqp.getJavaEEVersion() == 80) {
                try {
                    org.eclipse.jst.javaee.application.Application application = (org.eclipse.jst.javaee.application.Application)this.archive.getModelObject();
                    List modules = application.getModules();
                    int i = 0;
                    while (i < modules.size()) {
                        Module module = (Module)modules.get(i);
                        String uri = module.getUri();
                        this.cachedDDMappedModuleURIs.add(uri);
                        ++i;
                    }
                }
                catch (ArchiveModelLoadException e) {
                    J2EEPlugin.logError(e);
                }
            } else {
                try {
                    Application application = (Application)this.archive.getModelObject();
                    EList modules = application.getModules();
                    int i = 0;
                    while (i < modules.size()) {
                        org.eclipse.jst.j2ee.application.Module module = (org.eclipse.jst.j2ee.application.Module)modules.get(i);
                        String uri = module.getUri();
                        this.cachedDDMappedModuleURIs.add(uri);
                        ++i;
                    }
                }
                catch (ArchiveModelLoadException e) {
                    J2EEPlugin.logError(e);
                }
            }
        }
        return this.cachedDDMappedModuleURIs;
    }

    public List<ArchiveWrapper> getEarModules() {
        if (this.cachedEARModules != null) {
            return this.cachedEARModules;
        }
        if (this.jqp.getType() != 1) {
            this.fail();
        }
        this.cachedEARModules = new ArrayList<ArchiveWrapper>();
        if (this.jqp.getJavaEEVersion() == 50 || this.jqp.getJavaEEVersion() == 60 || this.jqp.getJavaEEVersion() == 70 || this.jqp.getJavaEEVersion() == 80) {
            List resources = this.archive.getArchiveResources();
            for (IArchiveResource resource : resources) {
                String lastSegment;
                IPath path;
                if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 0 || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip") && !lastSegment.endsWith("rar") && !lastSegment.endsWith("war")) continue;
                try {
                    IArchive earmodule = this.archive.getNestedArchive(resource);
                    this.cachedEARModules.add(new ArchiveWrapper(earmodule));
                }
                catch (ArchiveOpenFailureException e) {
                    J2EEPlugin.logError(e);
                }
            }
        } else {
            try {
                Application app = (Application)this.archive.getModelObject();
                EList modules = app.getModules();
                int i = 0;
                while (i < modules.size()) {
                    org.eclipse.jst.j2ee.application.Module mod = (org.eclipse.jst.j2ee.application.Module)modules.get(i);
                    String uri = mod.getUri();
                    Path path = new Path(uri);
                    if (this.archive.containsArchiveResource((IPath)path)) {
                        try {
                            IArchiveResource resource = this.archive.getArchiveResource((IPath)path);
                            IArchive earmodule = this.archive.getNestedArchive(resource);
                            this.cachedEARModules.add(new ArchiveWrapper(earmodule));
                        }
                        catch (ArchiveOpenFailureException e) {
                            J2EEPlugin.logError(e);
                        }
                        catch (FileNotFoundException e) {
                            J2EEPlugin.logError(e);
                        }
                    }
                    ++i;
                }
            }
            catch (ArchiveModelLoadException e) {
                J2EEPlugin.logError(e);
            }
        }
        return this.cachedEARModules;
    }

    public String getName() {
        return this.archive.getPath().lastSegment();
    }

    public boolean isModule() {
        if (this.isApplicationClientFile()) {
            return true;
        }
        if (this.isWARFile()) {
            return true;
        }
        if (this.isEJBJarFile()) {
            return true;
        }
        return this.isRARFile();
    }

    public boolean isApplicationClientFile() {
        return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 3;
    }

    public boolean isWARFile() {
        return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 4;
    }

    public boolean isEJBJarFile() {
        return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 0;
    }

    public boolean isEarFile() {
        return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 1;
    }

    public boolean isRARFile() {
        return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 2;
    }

    public String getWebContextRoot() {
        block12: {
            if (this.cachedWebContextRoot != null) {
                return this.cachedWebContextRoot[0];
            }
            if (!this.isWARFile()) {
                this.fail();
                return null;
            }
            this.cachedWebContextRoot = new String[1];
            IArchive earArchive = this.archive.getArchive();
            if (earArchive.containsArchiveResource((IPath)new Path("META-INF/application.xml"))) {
                JavaEEQuickPeek earJQP = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(earArchive);
                if (earJQP.getJavaEEVersion() == 50 || earJQP.getJavaEEVersion() == 60 || earJQP.getJavaEEVersion() == 70 || earJQP.getJavaEEVersion() == 80) {
                    try {
                        org.eclipse.jst.javaee.application.Application application = (org.eclipse.jst.javaee.application.Application)earArchive.getModelObject();
                        String moduleName = this.archive.getPath().toString();
                        Module module = application.getFirstModule(moduleName);
                        if (module != null) {
                            this.cachedWebContextRoot[0] = module.getWeb().getContextRoot();
                            break block12;
                        }
                        this.cachedWebContextRoot[0] = this.getDefaultContextRoot();
                    }
                    catch (ArchiveModelLoadException e) {
                        J2EEPlugin.logError(e);
                    }
                } else {
                    try {
                        Application application = (Application)earArchive.getModelObject();
                        String moduleName = this.archive.getPath().toString();
                        WebModule module = (WebModule)application.getFirstModule(moduleName);
                        if (module == null) {
                            this.cachedWebContextRoot[0] = null;
                            break block12;
                        }
                        this.cachedWebContextRoot[0] = module.getContextRoot();
                    }
                    catch (ArchiveModelLoadException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            } else {
                this.cachedWebContextRoot[0] = this.getDefaultContextRoot();
            }
        }
        return this.cachedWebContextRoot[0];
    }

    private String getDefaultContextRoot() {
        String contextRoot = this.archive.getPath().toString();
        contextRoot = contextRoot.substring(0, contextRoot.lastIndexOf(46));
        return contextRoot;
    }

    public ArchiveWrapper getEJBClientArchiveWrapper(ArchiveWrapper ejbWrapper) {
        if (this.cachedEJBClientArchiveWrapper == null) {
            this.cachedEJBClientArchiveWrapper = new HashMap();
        }
        if (this.cachedEJBClientArchiveWrapper.containsKey(ejbWrapper)) {
            return this.cachedEJBClientArchiveWrapper.get(ejbWrapper);
        }
        if (!ejbWrapper.isEJBJarFile() || !this.isEarFile()) {
            this.fail();
            return null;
        }
        ArchiveWrapper ejbClientArchiveWrapper = null;
        try {
            try {
                JavaEEQuickPeek jqp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(ejbWrapper.archive);
                String clientJarName = null;
                if (jqp.getVersion() == 30 || jqp.getVersion() == 31 || jqp.getVersion() == 32) {
                    if (ejbWrapper.archive.containsArchiveResource((IPath)new Path("META-INF/ejb-jar.xml"))) {
                        EJBJar edd = (EJBJar)ejbWrapper.archive.getModelObject();
                        clientJarName = edd.getEjbClientJar();
                    }
                } else {
                    org.eclipse.jst.j2ee.ejb.EJBJar jar = (org.eclipse.jst.j2ee.ejb.EJBJar)ejbWrapper.archive.getModelObject();
                    if (jar != null) {
                        clientJarName = jar.getEjbClientJar();
                    }
                }
                if (clientJarName != null) {
                    Path clientJarPath = new Path(clientJarName);
                    if (this.archive.containsArchiveResource((IPath)clientJarPath)) {
                        IArchiveResource clientJar = this.archive.getArchiveResource((IPath)clientJarPath);
                        if (clientJar != null) {
                            if (clientJar.getType() == 2) {
                                ejbClientArchiveWrapper = new ArchiveWrapper((IArchive)clientJar);
                            } else {
                                try {
                                    ejbClientArchiveWrapper = new ArchiveWrapper(this.archive.getNestedArchive(clientJar));
                                }
                                catch (ArchiveOpenFailureException e) {
                                    J2EEPlugin.logError(e);
                                }
                            }
                        }
                    } else {
                        J2EEPlugin.logWarning(EARArchiveOpsResourceHandler.bind((String)EARArchiveOpsResourceHandler.MISSING_CLIENT_JAR, (Object[])new Object[]{clientJarName, ejbWrapper.getName(), this.archive.getPath()}));
                    }
                }
            }
            catch (FileNotFoundException e) {
                J2EEPlugin.logError(e);
                this.cachedEJBClientArchiveWrapper.put(ejbWrapper, ejbClientArchiveWrapper);
            }
            catch (ArchiveModelLoadException e) {
                J2EEPlugin.logError(e);
                this.cachedEJBClientArchiveWrapper.put(ejbWrapper, ejbClientArchiveWrapper);
            }
        }
        finally {
            this.cachedEJBClientArchiveWrapper.put(ejbWrapper, ejbClientArchiveWrapper);
        }
        return ejbClientArchiveWrapper;
    }

    public List<ArchiveWrapper> getEARUtilitiesAndWebLibs() {
        if (this.cachedEARUtilitiesAndWebLibs != null) {
            return this.cachedEARUtilitiesAndWebLibs;
        }
        if (!this.isEarFile()) {
            this.fail();
            return null;
        }
        this.cachedEARUtilitiesAndWebLibs = new ArrayList<ArchiveWrapper>();
        List files = this.archive.getArchiveResources();
        int i = 0;
        while (i < files.size()) {
            IArchiveResource file = (IArchiveResource)files.get(i);
            String lastSegment = file.getPath().lastSegment();
            if (lastSegment.endsWith(".jar") || lastSegment.endsWith(".rar") || lastSegment.endsWith(".war") || lastSegment.endsWith("zip")) {
                try {
                    IArchive nestedArchive = this.archive.getNestedArchive(file);
                    ArchiveWrapper nestedWrapper = new ArchiveWrapper(nestedArchive);
                    if (nestedWrapper.isWARFile()) {
                        this.cachedEARUtilitiesAndWebLibs.addAll(nestedWrapper.getWebLibs());
                    } else if (!nestedWrapper.isModule()) {
                        this.cachedEARUtilitiesAndWebLibs.add(nestedWrapper);
                    }
                }
                catch (ArchiveOpenFailureException e) {
                    J2EEPlugin.logError(e);
                }
            }
            ++i;
        }
        return this.cachedEARUtilitiesAndWebLibs;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || !(otherObject instanceof ArchiveWrapper)) {
            return false;
        }
        ArchiveWrapper other = (ArchiveWrapper)otherObject;
        if (this.archive != null) {
            return this.archive.equals(other.archive);
        }
        return false;
    }

    public int hashCode() {
        if (this.archive != null) {
            return this.archive.hashCode();
        }
        return super.hashCode();
    }
}

