/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.utils.SelectionHelper;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DesignerPropertyTool {
    public static String getAttributeValue(Element fNode, CMNode attributeDesc) {
        Node attribute;
        if (attributeDesc == null) {
            return "";
        }
        String returnedValue = "";
        NamedNodeMap attrMap = fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(attributeDesc.getNodeName())) != null) {
            returnedValue = attribute instanceof IDOMNode ? ((IDOMNode)attribute).getValueSource() : attribute.getNodeValue();
        }
        return returnedValue;
    }

    public static CMNamedNodeMap getElementDeclaredAttributes(Node fNode) {
        ModelQuery modelQuery;
        IDOMModel structModel = null;
        if (fNode instanceof IDOMNode) {
            structModel = ((IDOMNode)fNode).getModel();
        }
        if (structModel == null) {
            return null;
        }
        CMElementDeclaration cmde = null;
        CMNamedNodeMap cmnnm = null;
        if (fNode == null || fNode.getNodeType() != 1) {
            cmde = null;
        }
        if ((modelQuery = ModelQueryUtil.getModelQuery((Document)fNode.getOwnerDocument())) != null) {
            cmde = modelQuery.getCMElementDeclaration((Element)fNode);
        }
        if (cmde != null) {
            cmnnm = cmde.getAttributes();
        }
        return cmnnm;
    }

    public static Node normalizeSelectionToElement(IWorkbenchPart selectingPart, ISelection selection, HTMLEditor htmlEditor) {
        Node node = null;
        if (selectingPart instanceof HTMLEditor) {
            IEditorPart part = ((HTMLEditor)selectingPart).getActiveEditor();
            if (part instanceof TextEditor) {
                if (selection instanceof ITextSelection) {
                    IStructuredModel model = ((HTMLEditor)selectingPart).getModel();
                    node = SelectionHelper.toNode(model, (ITextSelection)selection);
                }
            } else if (part instanceof GraphicalEditor) {
                if (selection instanceof IStructuredSelection) {
                    node = SelectionHelper.toNode((IStructuredSelection)selection);
                } else if (selection instanceof DesignRange) {
                    node = SelectionHelper.toNode((DesignRange)selection);
                }
            }
            if (node instanceof Attr) {
                node = ((Attr)node).getOwnerElement();
            } else if (node instanceof Text || node instanceof CDATASection) {
                node = node.getParentNode();
            }
        } else if (selectingPart instanceof ContentOutline && selection instanceof IStructuredSelection && ((ContentOutline)selectingPart).getCurrentPage() != null && ((ContentOutline)selectingPart).getCurrentPage().getControl().isFocusControl() && (node = SelectionHelper.toNode((IStructuredSelection)selection)) == null) {
            node = htmlEditor.getDOMDocument();
        }
        return node;
    }

    public static Element getElementNode(Object node) {
        Element element = null;
        if (node == null) {
            return null;
        }
        if (node instanceof Element) {
            element = (Element)node;
        } else if (node instanceof AbstractEditPart) {
            Object model = ((AbstractEditPart)node).getModel();
            if (model instanceof Element) {
                element = (Element)model;
            }
        } else if (node instanceof ISelection) {
            element = DesignerPropertyTool.getElement(null, (ISelection)node);
        }
        return element;
    }

    public static List getNameList(Element element, String[] filter) {
        ArrayList<String> result = new ArrayList<String>();
        CMNamedNodeMap attributes = DesignerPropertyTool.getElementDeclaredAttributes(element);
        if (attributes != null) {
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                String name = attributes.item(i).getNodeName();
                if (Arrays.asList(filter).contains(name)) {
                    result.add(name);
                }
                ++i;
            }
        }
        return result;
    }

    public static Node getCommonParent(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            return (Node)obj;
        }
        if (selection instanceof DesignRange) {
            DesignRange range = (DesignRange)selection;
            Node node1 = range.getStartPosition().getContainerNode();
            Node node2 = range.getEndPosition().getContainerNode();
            return DOMUtil.findCommonAncester(node1, node2);
        }
        return null;
    }

    public static Element getElement(IWorkbenchPart selectingPart, ISelection selection) {
        Node node = DesignerPropertyTool.getCommonParent(selection);
        if (node instanceof Element) {
            return (Element)node;
        }
        if (node != null && (node = node.getParentNode()) instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    public static boolean isMultiSelection(Element element) {
        if (element.getNodeName().equalsIgnoreCase("option")) {
            return element.getAttribute("multiple") != null;
        }
        return false;
    }

    public static IJavaProject getJavaProject(Object project) {
        if (project == null) {
            return null;
        }
        if (project instanceof IJavaProject) {
            return (IJavaProject)project;
        }
        if (project instanceof IProject) {
            IProjectNature nature;
            block6: {
                try {
                    nature = ((IProject)project).getNature("org.eclipse.jdt.core.javanature");
                    if (nature != null) break block6;
                    return null;
                }
                catch (Exception e) {
                    PDPlugin.getLogger(DesignerPropertyTool.class).error("Error.DesignerPropertyTool.NatureQuerying", (Throwable)e);
                    return null;
                }
            }
            return (IJavaProject)nature;
        }
        return null;
    }
}

