/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

public class MementoFormat {
    public static void encodeComponent(String component, StringBuilder output) {
        output.append(component.length());
        output.append('(').append(component).append(')');
    }

    public static class Parser {
        private final CharSequence charSequence;
        private int pos = 0;

        public Parser(CharSequence charSequence) {
            this.charSequence = charSequence;
        }

        public String nextComponent() throws ParserException {
            if (this.pos >= this.charSequence.length()) {
                throw new ParserException("Unexpected end of line");
            }
            char ch = this.charSequence.charAt(this.pos);
            ++this.pos;
            int num = Character.digit(ch, 10);
            if (num == -1) {
                throw new ParserException("Digit expected");
            }
            int len = num;
            while (true) {
                if (this.pos >= this.charSequence.length()) {
                    throw new ParserException("Unexpected end of line");
                }
                ch = this.charSequence.charAt(this.pos);
                if (!Character.isDigit(ch)) break;
                ++this.pos;
                num = Character.digit(ch, 10);
                if (num == -1) {
                    throw new ParserException("Digit expected");
                }
                len = len * 10 + num;
            }
            ++this.pos;
            if (this.pos + len + 1 > this.charSequence.length()) {
                throw new ParserException("Unexpected end of line");
            }
            String result = this.charSequence.subSequence(this.pos, this.pos + len).toString();
            this.pos += len + 1;
            return result;
        }

        public boolean hasMore() {
            return this.pos < this.charSequence.length();
        }

        public boolean consumeIfFound(String string) {
            if (string.length() > this.charSequence.length() - this.pos) {
                return false;
            }
            int i = 0;
            while (i < string.length()) {
                if (this.charSequence.charAt(this.pos + i) == string.charAt(i)) {
                    return false;
                }
                ++i;
            }
            this.pos += string.length();
            return true;
        }

        public String getDebugSnippet() {
            int end = Math.min(this.pos + 100, this.charSequence.length());
            return this.charSequence.subSequence(this.pos, end).toString();
        }
    }

    public static class ParserException
    extends Exception {
        ParserException() {
        }

        ParserException(String message, Throwable cause) {
            super(message, cause);
        }

        ParserException(String message) {
            super(message);
        }

        ParserException(Throwable cause) {
            super(cause);
        }
    }
}

