/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.resources;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.utils.exception.MissingResourceException;
import org.eclipse.jst.ws.jaxws.utils.facets.FacetUtils;
import org.eclipse.jst.ws.jaxws.utils.facets.IFacetUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.text.JaxWsUtilMessages;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

public final class ProjectManagementUtils {
    private static final ILogger logger = new Logger();

    public static IFolder findMetaInfFolder(String pProjectName) throws MissingResourceException {
        if (!ProjectManagementUtils.isEjb3Project(pProjectName)) {
            throw new IllegalArgumentException("Project " + pProjectName + " is not an EJB project");
        }
        IProject project = ProjectManagementUtils.getProjectByName(pProjectName);
        IJavaProject javaProject = ProjectManagementUtils.getJavaProject(project);
        IPackageFragment ejbModulePkgFragment = null;
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot.getKind() == 1 && fragmentRoot.getElementName().equals("ejbModule")) {
                    ejbModulePkgFragment = fragmentRoot.getPackageFragment("META-INF");
                }
                ++n2;
            }
            ProjectManagementUtils.verifyMetaInfFolder(ejbModulePkgFragment, pProjectName);
            return (IFolder)ejbModulePkgFragment.getCorrespondingResource();
        }
        catch (JavaModelException e) {
            logger.logError(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void verifyMetaInfFolder(IPackageFragment fragment, String projectName) throws MissingResourceException {
        if (fragment == null) {
            String msg = MessageFormat.format("project {0} does not have a META-INF folder", projectName);
            String localizedMsg = MessageFormat.format(JaxWsUtilMessages.ProjectManagementUtils_ProjectHasNoMetaInfFolderMsg, projectName);
            throw new MissingResourceException(msg, localizedMsg);
        }
        try {
            IResource resource = fragment.getCorrespondingResource();
            if (!(resource instanceof IFolder)) {
                throw new RuntimeException("Resource " + resource.getName() + " is not a folder");
            }
        }
        catch (JavaModelException e) {
            logger.logError(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isEjb3Project(String projectName) {
        IProject project = ProjectManagementUtils.getProjectByName(projectName);
        try {
            return ProjectManagementUtils.facetUtils().hasFacetWithVersion(project, "3.0", "jst.ejb", true);
        }
        catch (CoreException e) {
            logger.logError(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isWeb25Project(String projectName) {
        IProject project = ProjectManagementUtils.getProjectByName(projectName);
        try {
            return ProjectManagementUtils.facetUtils().hasFacetWithVersion(project, "2.5", "jst.web", true);
        }
        catch (CoreException e) {
            logger.logError(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static IProject getProjectByName(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            throw new IllegalArgumentException("Illegal project name: " + projectName);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible()) {
            throw new IllegalStateException("Project is not accessible");
        }
        return project;
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project == null || !project.isAccessible()) {
            throw new IllegalArgumentException("Project is not accessible");
        }
        return JavaCore.create((IProject)project);
    }

    public static void refreshResource(IResource resource) throws CoreException {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        resource.refreshLocal(0, null);
    }

    public static void refreshProjectByResource(IResource resource) throws CoreException {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        if (resource instanceof IWorkspaceRoot) {
            throw new IllegalArgumentException("Operation is not defined for workspace roots");
        }
        resource.getProject().refreshLocal(2, null);
    }

    private static IFacetUtils facetUtils() {
        return new FacetUtils();
    }
}

