/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.geronimo.javamail.store.pop3.POP3Command;
import org.apache.geronimo.javamail.store.pop3.POP3Response;
import org.apache.geronimo.javamail.store.pop3.POP3ResponseBuilder;

public class POP3Connection {
    protected static final String MAIL_SSLFACTORY_CLASS = "mail.SSLSocketFactory.class";
    protected static final String MAIL_POP3_FACTORY_CLASS = "socketFactory.class";
    protected static final String MAIL_POP3_FACTORY_FALLBACK = "socketFactory.fallback";
    protected static final String MAIL_POP3_FACTORY_PORT = "socketFactory.port";
    protected static final String MAIL_POP3_LOCALADDRESS = "localAddress";
    protected static final String MAIL_POP3_LOCALPORT = "localPort";
    protected static final String MAIL_POP3_TIMEOUT = "timeout";
    private Socket socket;
    private Session session;
    private String host;
    private int port;
    private PrintWriter writer;
    private BufferedReader reader;
    private String protocol;
    private boolean sslConnection;

    POP3Connection(Session session, String host, int port, boolean sslConnection, String protocol) {
        this.session = session;
        this.host = host;
        this.port = port;
        this.sslConnection = sslConnection;
        this.protocol = protocol;
    }

    public void open() throws Exception {
        try {
            if (!this.sslConnection) {
                this.getConnectedSocket();
            } else {
                this.getConnectedSSLSocket();
            }
            if (this.session.getDebug()) {
                this.session.getDebugOut().println("Connection successful " + this.toString());
            }
            this.buildInputReader();
            this.buildOutputWriter();
            if (this.session.getDebug()) {
                this.session.getDebugOut().println("Greeting from server " + this.reader.readLine());
            } else {
                this.reader.readLine();
            }
        }
        catch (IOException e) {
            Exception ex = new Exception("Error opening connection " + this.toString(), e);
            throw ex;
        }
    }

    void close() throws Exception {
        try {
            this.socket.close();
            if (this.session.getDebug()) {
                this.session.getDebugOut().println("Connection successfuly closed " + this.toString());
            }
        }
        catch (IOException e) {
            Exception ex = new Exception("Error closing connection " + this.toString(), e);
            throw ex;
        }
    }

    public synchronized POP3Response sendCommand(POP3Command cmd) throws MessagingException {
        if (this.socket.isConnected()) {
            if (this.socket.isOutputShutdown()) {
                this.buildOutputWriter();
            }
            if (this.socket.isInputShutdown()) {
                this.buildInputReader();
            }
            if (this.session.getDebug()) {
                this.session.getDebugOut().println("\nCommand sent " + cmd.getCommand());
            }
            POP3Response res = null;
            this.writer.write(cmd.getCommand());
            this.writer.flush();
            res = POP3ResponseBuilder.buildResponse(this.session, this.reader, cmd.isMultiLineResponse());
            return res;
        }
        throw new MessagingException("Connection to Mail Server is lost, connection " + this.toString());
    }

    private void buildInputReader() throws MessagingException {
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (IOException e) {
            throw new MessagingException("Error obtaining input stream " + this.toString(), e);
        }
    }

    private void buildOutputWriter() throws MessagingException {
        try {
            this.writer = new PrintWriter(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            throw new MessagingException("Error obtaining output stream " + this.toString(), e);
        }
    }

    public String toString() {
        return "POP3Connection host: " + this.host + " port: " + this.port;
    }

    protected void getConnectedSocket() throws IOException {
        String socketFactory = this.getProtocolProperty(MAIL_POP3_FACTORY_CLASS);
        int timeout = this.getIntProtocolProperty(MAIL_POP3_TIMEOUT, -1);
        InetAddress localAddress = null;
        String localAddrProp = this.getProtocolProperty(MAIL_POP3_LOCALADDRESS);
        if (localAddrProp != null) {
            localAddress = InetAddress.getByName(localAddrProp);
        }
        int localPort = this.getIntProtocolProperty(MAIL_POP3_LOCALPORT, 0);
        this.socket = null;
        if (socketFactory == null) {
            this.socket = new Socket(this.host, this.port, localAddress, localPort);
        } else {
            try {
                int socketFactoryPort = this.getIntProtocolProperty(MAIL_POP3_FACTORY_PORT, -1);
                Integer portArg = new Integer(socketFactoryPort == -1 ? this.port : socketFactoryPort);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(socketFactory);
                Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                Object defFactory = getDefault.invoke(new Object(), new Object[0]);
                if (localAddress != null) {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE, InetAddress.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg, localAddress, new Integer(localPort)};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                } else {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                }
            }
            catch (Throwable e) {
                if (this.isProtocolPropertyTrue(MAIL_POP3_FACTORY_FALLBACK)) {
                    this.socket = new Socket(this.host, this.port, localAddress, localPort);
                }
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                IOException ioe = new IOException("Error connecting to " + this.host + ", " + this.port);
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    protected void getConnectedSSLSocket() throws IOException {
        if (this.session.getDebug()) {
            this.session.getDebugOut().println("Attempting SSL socket connection to server " + this.host + ":" + this.port);
        }
        String socketFactory = this.getProtocolProperty(MAIL_POP3_FACTORY_CLASS, this.getSessionProperty(MAIL_SSLFACTORY_CLASS, "javax.net.ssl.SSLSocketFactory"));
        int timeout = this.getIntProtocolProperty(MAIL_POP3_TIMEOUT, -1);
        InetAddress localAddress = null;
        String localAddrProp = this.getProtocolProperty(MAIL_POP3_LOCALADDRESS);
        if (localAddrProp != null) {
            localAddress = InetAddress.getByName(localAddrProp);
        }
        int localPort = this.getIntProtocolProperty(MAIL_POP3_LOCALPORT, 0);
        this.socket = null;
        if (socketFactory == null) {
            System.out.println("SocketFactory was null so creating the connection using a default");
            this.socket = new Socket(this.host, this.port, localAddress, localPort);
        } else {
            boolean fallback = this.isProtocolPropertyTrue(MAIL_POP3_FACTORY_FALLBACK);
            while (true) {
                try {
                    while (this.socket == null || !this.socket.isConnected()) {
                        Object[] createSocketArgs;
                        Method createSocket;
                        Class[] createSocketSig;
                        int socketFactoryPort;
                        if (this.session.getDebug()) {
                            this.session.getDebugOut().println("Creating SSL socket using factory " + socketFactory);
                        }
                        Integer portArg = new Integer((socketFactoryPort = this.getIntProtocolProperty(MAIL_POP3_FACTORY_PORT, -1)) == -1 ? this.port : socketFactoryPort);
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        Class<?> factoryClass = loader.loadClass(socketFactory);
                        Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                        Object defFactory = getDefault.invoke(new Object(), new Object[0]);
                        if (localAddress != null) {
                            createSocketSig = new Class[]{class$java$lang$String == null ? POP3Connection.class$("java.lang.String") : class$java$lang$String, Integer.TYPE, class$java$net$InetAddress == null ? POP3Connection.class$("java.net.InetAddress") : class$java$net$InetAddress, Integer.TYPE};
                            createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                            createSocketArgs = new Object[]{this.host, portArg, localAddress, new Integer(localPort)};
                            this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                            continue;
                        }
                        createSocketSig = new Class[]{class$java$lang$String == null ? POP3Connection.class$("java.lang.String") : class$java$lang$String, Integer.TYPE};
                        createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                        createSocketArgs = new Object[]{this.host, portArg};
                        this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                    }
                }
                catch (Throwable e) {
                    if (this.session.getDebug()) {
                        this.session.getDebugOut().println("First attempt at creating SSL socket failed, falling back to default factory");
                    }
                    if (fallback) {
                        socketFactory = "javax.net.ssl.SSLSocketFactory";
                        fallback = false;
                        continue;
                    }
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    if (this.session.getDebug()) {
                        this.session.getDebugOut().println("Failure creating SSL socket: " + e);
                    }
                    IOException ioe = new IOException("Error connecting to " + this.host + ", " + this.port);
                    ioe.initCause(e);
                    throw ioe;
                }
                break;
            }
        }
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    protected boolean isProtocolPropertyTrue(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.isSessionPropertyTrue(fullName);
    }

    protected boolean isSessionPropertyTrue(String name) {
        String property = this.session.getProperty(name);
        if (property != null) {
            return property.equals("true");
        }
        return false;
    }

    protected int getIntProtocolProperty(String name, int defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getIntSessionProperty(fullName, defaultValue);
    }

    protected int getIntSessionProperty(String name, int defaultValue) {
        String result = this.getSessionProperty(name);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected String getSessionProperty(String name, String defaultValue) {
        String result = this.session.getProperty(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    protected String getProtocolProperty(String name, String defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getSessionProperty(fullName, defaultValue);
    }

    protected String getProtocolProperty(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getSessionProperty(fullName);
    }

    protected String getSessionProperty(String name) {
        return this.session.getProperty(name);
    }
}

