/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentReferenceProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.BaseAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentLoader;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentManagerImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentReferenceImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ExternalSchemaLocationProviderRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLAssociationProvider
extends BaseAssociationProvider
implements CMDocumentReferenceProvider {
    protected CMDocumentCache cmDocumentCache;
    protected CMDocumentManagerImpl documentManager;
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/externalSchemaLocation"));

    public XMLAssociationProvider(CMDocumentCache cmDocumentCache) {
        this.cmDocumentCache = cmDocumentCache;
        this.documentManager = new CMDocumentManagerImpl(cmDocumentCache, this);
    }

    public CMDocumentManager getCMDocumentManager() {
        return this.documentManager;
    }

    public static String[] getDoctypeInfo(Document document) {
        String[] result = null;
        DocumentType doctype = document.getDoctype();
        if (doctype != null && (doctype.getPublicId() != null || doctype.getSystemId() != null)) {
            result = new String[]{doctype.getPublicId(), doctype.getSystemId()};
        } else if (XMLAssociationProvider.getImplictDoctype(document) != null) {
            result = XMLAssociationProvider.getImplictDoctype(document);
        }
        return result;
    }

    protected static String[] getImplictDoctype(Document document) {
        String[] result = null;
        return result;
    }

    @Override
    public CMDocument getCorrespondingCMDocument(Node node) {
        return this.getCorrespondingCMDocument(node, true);
    }

    protected CMDocument getCorrespondingCMDocument(Node node, boolean getDocumentFromCMNode) {
        CMDocument result = null;
        try {
            CMNode cmNode;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            String[] doctypeInfo = XMLAssociationProvider.getDoctypeInfo(document);
            if (doctypeInfo != null) {
                result = this.getCMDocument(doctypeInfo[0], doctypeInfo[1], "DTD");
            } else if (getDocumentFromCMNode && (cmNode = this.getCMNode(node)) != null) {
                result = (CMDocument)cmNode.getProperty("CMDocument");
            }
        }
        catch (Exception e) {
            Logger.logException("exception locating CMDocument for " + node, e);
        }
        return result;
    }

    public CMDocument getCMDocument(Element element, String uri) {
        CMDocument result = null;
        NamespaceTable namespaceTable = new NamespaceTable(element.getOwnerDocument());
        namespaceTable.addElementLineage(element);
        NamespaceInfo namespaceInfo = namespaceTable.getNamespaceInfoForURI(uri);
        if (namespaceInfo != null) {
            result = this.getCMDocument(namespaceInfo.uri, namespaceInfo.locationHint, "XSD");
        }
        return result;
    }

    public CMDocument getCMDocument(String publicId, String systemId, String type) {
        return this.documentManager.getCMDocument(publicId, systemId, type);
    }

    @Override
    public String resolveGrammarURI(String publicId, String systemId) {
        return this.resolveGrammarURI(null, publicId, systemId);
    }

    protected String resolveGrammarURI(Document document, String publicId, String systemId) {
        return systemId;
    }

    @Override
    public CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration result = null;
        Document document = element.getOwnerDocument();
        String[] doctypeInfo = XMLAssociationProvider.getDoctypeInfo(document);
        if (doctypeInfo != null) {
            Node parent;
            CMDocument cmDocument = this.getCorrespondingCMDocument(element, false);
            if (cmDocument != null && (result = (CMElementDeclaration)cmDocument.getElements().getNamedItem(element.getNodeName())) == null && XMLAssociationProvider.getImplictDoctype(document) != null && (parent = element.getParentNode()) != null && parent.getNodeType() == 1) {
                result = this.getCMElementDeclaration((Element)parent);
            }
        } else {
            NamespaceTable namespaceTable = new NamespaceTable(element.getOwnerDocument());
            List list = NamespaceTable.getElementLineage(element);
            Element rootElement = (Element)list.get(0);
            namespaceTable.addElement(rootElement);
            if (namespaceTable.isNamespaceEncountered()) {
                result = this.getCMElementDeclaration(element, list, namespaceTable);
            } else {
                result = this.checkExternalSchema(element);
                if (result == null) {
                    CMDocument cmDocument = this.getCMDocument("", "", "DTD");
                    if (cmDocument != null) {
                        result = (CMElementDeclaration)cmDocument.getElements().getNamedItem(element.getNodeName());
                    } else {
                        IPath path = CMDocumentLoader.getInternalSubsetPath(document);
                        if (!Path.EMPTY.equals((Object)path) && (cmDocument = this.getCMDocument(path.toPortableString(), path.toFile().toURI().toString(), "DTD")) != null) {
                            result = (CMElementDeclaration)cmDocument.getElements().getNamedItem(element.getNodeName());
                        }
                    }
                }
            }
        }
        return result;
    }

    protected CMElementDeclaration checkExternalSchema(Element element) {
        String baseLocation;
        Document document = element.getOwnerDocument();
        if (document instanceof IDOMDocument && (baseLocation = ((IDOMDocument)document).getModel().getBaseLocation()) != null) {
            URI uri;
            Path basePath = new Path(baseLocation);
            IFile file = null;
            if (basePath.segmentCount() > 1) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath);
            }
            URI uRI = uri = file == null || !file.isAccessible() ? new File(baseLocation).toURI() : file.getLocationURI();
            if (uri != null) {
                IExternalSchemaLocationProvider[] providers = ExternalSchemaLocationProviderRegistry.getInstance().getProviders();
                int i = 0;
                while (i < providers.length) {
                    Object location;
                    long diff;
                    long time = _trace ? System.currentTimeMillis() : 0L;
                    Map locations = providers[i].getExternalSchemaLocation(uri);
                    if (_trace && (diff = System.currentTimeMillis() - time) > 250L) {
                        Logger.log(1, "Schema location provider took [" + diff + "ms] for URI [" + uri + "]");
                    }
                    if (locations != null && !locations.isEmpty() && (location = locations.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) != null) {
                        return this.getCMElementDeclaration(element, NamespaceTable.getElementLineage(element), uri.toString(), location.toString());
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    protected CMElementDeclaration getCMElementDeclaration(Element targetElement, List list, String publicId, String systemId) {
        CMElementDeclaration currentED = null;
        try {
            int listSize = list.size();
            int i = 0;
            while (i < listSize) {
                CMDocument cmDocument;
                Element element = (Element)list.get(i);
                String nodeName = element.getNodeName();
                CMElementDeclaration ed = null;
                if (currentED != null) {
                    ed = (CMElementDeclaration)currentED.getLocalElements().getNamedItem(nodeName);
                }
                if (ed == null && (cmDocument = this.getCMDocument(publicId, systemId, "XSD")) != null) {
                    ed = (CMElementDeclaration)cmDocument.getElements().getNamedItem(nodeName);
                }
                currentED = ed;
                ++i;
            }
        }
        catch (Exception e) {
            Logger.logException("exception locating element declaration for " + targetElement, e);
        }
        return currentED;
    }

    protected CMElementDeclaration getCMElementDeclaration(Element targetElement, List list, NamespaceTable namespaceTable) {
        CMElementDeclaration currentED = null;
        try {
            int listSize = list.size();
            int i = 0;
            while (i < listSize) {
                CMElementDeclaration derivedED;
                CMDocument cmDocument;
                NamespaceInfo namespaceInfo;
                Element element = (Element)list.get(i);
                if (i != 0) {
                    namespaceTable.addElement(element);
                }
                String nodeName = element.getNodeName();
                String unprefixedName = DOMNamespaceHelper.getUnprefixedName(nodeName);
                String prefix = DOMNamespaceHelper.getPrefix(nodeName);
                CMElementDeclaration ed = null;
                if (currentED != null) {
                    ed = (CMElementDeclaration)currentED.getLocalElements().getNamedItem(unprefixedName);
                }
                if (ed == null && (namespaceInfo = namespaceTable.getNamespaceInfoForPrefix(prefix)) != null && (cmDocument = this.getCMDocument(namespaceInfo.uri, namespaceInfo.locationHint, "XSD")) != null) {
                    ed = (CMElementDeclaration)cmDocument.getElements().getNamedItem(unprefixedName);
                }
                if ((currentED = ed) != null && (derivedED = this.getDerivedCMElementDeclaration(element, currentED, namespaceTable)) != null) {
                    currentED = derivedED;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.logException("exception locating element declaration for " + targetElement, e);
        }
        return currentED;
    }

    protected CMElementDeclaration getDerivedCMElementDeclaration(Element element, CMElementDeclaration ed, NamespaceTable namespaceTable) {
        String xsiTypeValue;
        CMElementDeclaration result = null;
        String xsiPrefix = namespaceTable.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix != null && (xsiTypeValue = element.getAttribute(String.valueOf(xsiPrefix) + ":type")) != null && xsiTypeValue.length() > 0) {
            String typePrefix = DOMNamespaceHelper.getPrefix(xsiTypeValue);
            String typeName = DOMNamespaceHelper.getUnprefixedName(xsiTypeValue);
            String typeURI = namespaceTable.getURIForPrefix(typePrefix);
            String uriQualifiedTypeName = typeName;
            if (typeURI != null && typeURI.length() > 0) {
                uriQualifiedTypeName = "[" + typeURI + "]" + typeName;
            }
            if ((result = (CMElementDeclaration)ed.getProperty("DerivedElementDeclaration=" + uriQualifiedTypeName)) == null) {
                String locationHint;
                String reference = null;
                NamespaceInfo namespaceInfo = namespaceTable.getNamespaceInfoForPrefix(typePrefix);
                if (namespaceInfo != null && (locationHint = this.resolveGrammarURI(element.getOwnerDocument(), namespaceInfo.uri, namespaceInfo.locationHint)) != null) {
                    reference = "[" + locationHint + "]" + typeName;
                }
                if (reference != null) {
                    result = (CMElementDeclaration)ed.getProperty("ExternallyDerivedElementDeclaration=" + reference);
                }
            }
        }
        return result;
    }

    @Override
    public CMAttributeDeclaration getCMAttributeDeclaration(Attr attr) {
        CMElementDeclaration ed;
        CMAttributeDeclaration result = null;
        Element element = attr.getOwnerElement();
        if (element != null && (ed = this.getCMElementDeclaration(element)) != null && (result = (CMAttributeDeclaration)ed.getAttributes().getNamedItem(attr.getName())) == null) {
            String name = DOMNamespaceHelper.getUnprefixedName(attr.getName());
            result = (CMAttributeDeclaration)ed.getAttributes().getNamedItem(name);
        }
        return result;
    }

    @Override
    public List getCMDocumentReferences(Node node, boolean deep) {
        ArrayList<CMDocumentReferenceImpl> result = new ArrayList<CMDocumentReferenceImpl>();
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        DocumentType doctype = document.getDoctype();
        if (doctype != null && (doctype.getPublicId() != null || doctype.getSystemId() != null)) {
            String uri = this.resolveGrammarURI(document, doctype.getPublicId(), doctype.getSystemId());
            result.add(new CMDocumentReferenceImpl(doctype.getPublicId(), uri));
        } else if (XMLAssociationProvider.getImplictDoctype(document) != null) {
            String[] implicitDoctype = XMLAssociationProvider.getImplictDoctype(document);
            String uri = this.resolveGrammarURI(document, implicitDoctype[0], implicitDoctype[1]);
            result.add(new CMDocumentReferenceImpl(implicitDoctype[0], uri));
        } else {
            NamespaceTable namespaceTable = new NamespaceTable(document);
            if (node.getNodeType() == 1) {
                namespaceTable.addElement((Element)node);
            }
            if (deep) {
                this.addChildElementsToNamespaceTable(node, namespaceTable);
            }
            List list = namespaceTable.getNamespaceInfoList();
            for (NamespaceInfo info : list) {
                String uri = this.resolveGrammarURI(document, info.uri, info.locationHint);
                result.add(new CMDocumentReferenceImpl(info.uri, uri));
            }
        }
        return result;
    }

    protected void addChildElementsToNamespaceTable(Node node, NamespaceTable namespaceTable) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int nodeListLength = nodeList.getLength();
            int i = 0;
            while (i < nodeListLength) {
                Node childNode = nodeList.item(i);
                if (childNode.getNodeType() == 1) {
                    namespaceTable.addElement((Element)childNode);
                    this.addChildElementsToNamespaceTable(childNode, namespaceTable);
                }
                ++i;
            }
        }
    }
}

