/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionResultException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class WSI3006
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3006(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        this.failureDetailMessage = null;
        KeyedReference claimKeyedRef = null;
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        try {
            claimKeyedRef = this.conformanceClaimMade(tModel);
            if (claimKeyedRef == null) {
                throw new AssertionResultException("notApplicable");
            }
            if (!claimKeyedRef.getKeyValue().equals("http://ws-i.org/profiles/basic/1.0")) {
                throw new AssertionResultException("failed", "The tModel key is: [" + tModel.getTModelKey() + "].\nThe categoryBag is: [" + tModel.getCategoryBag() + "].");
            }
        }
        catch (AssertionResultException e) {
            this.result = e.getMessage();
            this.failureDetailMessage = e.getDetailMessage();
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private KeyedReference checkCategoryBag(UDDIProxy proxy, CategoryBag bag) {
        String conformanceKey = null;
        try {
            conformanceKey = UDDIUtils.getWSIConformanceTModelKey(proxy);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        boolean result = true;
        KeyedReference conformanceRef = null;
        if (bag != null) {
            Vector references = bag.getKeyedReferenceVector();
            int i = 0;
            while (i < references.size() && result) {
                KeyedReference ref = (KeyedReference)references.get(i);
                if (ref.getTModelKey().equalsIgnoreCase(conformanceKey)) {
                    result = true;
                    conformanceRef = ref;
                }
                ++i;
            }
        }
        return conformanceRef;
    }

    private KeyedReference conformanceClaimMade(TModel tModel) throws WSIException {
        if (tModel == null) {
            throw new IllegalArgumentException("tModel cannot be null");
        }
        CategoryBag bag = tModel.getCategoryBag();
        return this.checkCategoryBag(this.validator.uddiProxy, bag);
    }
}

