/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class FileUtil {
    public static void copy(String inputPath, String outputPath, String[] filteredExtensions) throws IOException {
        File inputPathFile = new File(inputPath);
        if (!inputPathFile.exists()) {
            return;
        }
        File outputPathFile = new File(outputPath);
        if (!outputPathFile.exists()) {
            if (outputPathFile.isDirectory()) {
                if (!outputPathFile.mkdirs()) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
                }
            } else if (!outputPathFile.getParentFile().mkdirs()) {
                AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
            }
        }
        Vector files = FileUtil.findFiles(inputPath, filteredExtensions);
        int i = 0;
        while (i < files.size()) {
            File in = (File)files.elementAt(i);
            String outFilePath = in.getAbsolutePath().substring(inputPath.length());
            outFilePath = String.valueOf(outputPath) + File.separator + outFilePath;
            File out = new File(outFilePath);
            File parent = new File(out.getParent());
            if (!parent.exists() && !parent.mkdirs()) {
                AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
            }
            FileUtil.copy(new FileInputStream(in), new FileOutputStream(out));
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream i = in;
            try {
                try (OutputStream o = out;){
                    int bytesRead;
                    byte[] buffer = new byte[512];
                    while ((bytesRead = i.read(buffer)) != -1) {
                        o.write(buffer, 0, bytesRead);
                    }
                }
                if (i == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (i == null) throw throwable;
                i.close();
                throw throwable;
            }
            i.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void createJarFromDirectory(String jarFileName, String jarDirectory, String[] filtertedExtensions) throws IOException {
        File directory = new File(jarDirectory);
        if (!directory.exists()) {
            return;
        }
        File jar = new File(jarFileName);
        if (!jar.exists() && !jar.getParentFile().mkdirs()) {
            AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{jar.getParentFile()}, false);
        }
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream((OutputStream)new FileOutputStream(jar), new Manifest());
            Vector files = FileUtil.findFiles(jarDirectory, filtertedExtensions);
            int i = 0;
            while (i < files.size()) {
                File file = (File)files.elementAt(i);
                String relativePathToDirectory = file.getAbsolutePath().substring(directory.getAbsolutePath().length() + 1);
                String entryName = relativePathToDirectory.replace('\\', '/');
                FileInputStream inStream = null;
                ByteArrayOutputStream byteStream = null;
                try {
                    inStream = new FileInputStream(file);
                    byteStream = new ByteArrayOutputStream();
                    int length = 0;
                    byte[] buffer = new byte[1024];
                    while ((length = inStream.read(buffer)) > 0) {
                        byteStream.write(buffer, 0, length);
                    }
                    byte[] arr = byteStream.toByteArray();
                    JarEntry meta = new JarEntry(entryName);
                    jarOut.putNextEntry(meta);
                    meta.setSize(arr.length);
                    meta.setCompressedSize(arr.length);
                    CRC32 crc = new CRC32();
                    crc.update(arr);
                    meta.setCrc(crc.getValue());
                    meta.setMethod(0);
                    jarOut.write(arr, 0, arr.length);
                    jarOut.closeEntry();
                }
                catch (Throwable throwable) {
                    Helper.close(byteStream);
                    Helper.close(inStream);
                    throw throwable;
                }
                Helper.close(byteStream);
                Helper.close(inStream);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Helper.close(jarOut);
            throw throwable;
        }
        Helper.close(jarOut);
    }

    public static Vector findFiles(String path, String[] filteredExtensions) {
        Vector files = new Vector();
        FileUtil.findFilesHelper(new File(path), filteredExtensions, files);
        return files;
    }

    private static void findFilesHelper(File file, String[] filteredExtensions, Vector result) {
        block6: {
            block5: {
                if (!file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block5;
                String[] entries = file.list();
                if (entries == null) break block6;
                int i = 0;
                while (i < entries.length) {
                    FileUtil.findFilesHelper(new File(file, entries[i]), filteredExtensions, result);
                    ++i;
                }
                break block6;
            }
            if (filteredExtensions == null || filteredExtensions.length == 0) {
                result.addElement(file);
                return;
            }
            int i = 0;
            while (i < filteredExtensions.length) {
                if (file.getName().endsWith(filteredExtensions[i])) {
                    result.addElement(file);
                    return;
                }
                ++i;
            }
        }
    }

    public static void delete(File file) {
        Objects.requireNonNull(file);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] entries = file.list();
            if (entries == null || entries.length == 0) {
                if (!file.delete()) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
                }
            } else {
                int i = 0;
                while (i < entries.length) {
                    FileUtil.delete(new File(file, entries[i]));
                    ++i;
                }
                String[] content = file.list();
                if (!(content != null && content.length != 0 || file.delete())) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
                }
            }
        } else if (!file.delete()) {
            AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
        }
    }
}

