/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.EclipseLinkNullWriteTransformerColumnAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.EclipseLinkSourceTransformerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.WriteTransformerAnnotation;

public final class EclipseLinkSourceWriteTransformerAnnotation
extends EclipseLinkSourceTransformerAnnotation
implements WriteTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.WriteTransformer");
    private final ElementAnnotationAdapter columnAdapter;
    private ColumnAnnotation column;
    private final ColumnAnnotation nullColumn;

    public EclipseLinkSourceWriteTransformerAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.columnAdapter = new ElementAnnotationAdapter(this.annotatedElement, EclipseLinkSourceWriteTransformerAnnotation.buildColumnAnnotationAdapter(this.daa));
        this.nullColumn = this.buildNullColumn();
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.WriteTransformer";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        Annotation columnAnnotation = this.columnAdapter.getAnnotation(astRoot);
        if (columnAnnotation != null) {
            this.column = EclipseLinkSourceWriteTransformerAnnotation.createColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
            this.column.initialize(columnAnnotation);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.column == null;
    }

    @Override
    String getTransformerClassElementName() {
        return "transformerClass";
    }

    @Override
    String getMethodElementName() {
        return "method";
    }

    @Override
    public ColumnAnnotation getColumn() {
        return this.column;
    }

    @Override
    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : this.nullColumn;
    }

    @Override
    public ColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = EclipseLinkSourceWriteTransformerAnnotation.createColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    @Override
    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        ColumnAnnotation old = this.column;
        this.column = null;
        old.removeAnnotation();
    }

    private void syncColumn(CompilationUnit astRoot) {
        Annotation columnAnnotation = this.columnAdapter.getAnnotation(astRoot);
        if (columnAnnotation == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            ColumnAnnotation col = EclipseLinkSourceWriteTransformerAnnotation.createColumn((JavaResourceModel)this, this.annotatedElement, this.daa);
            col.initialize(columnAnnotation);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(columnAnnotation);
        }
    }

    private void syncColumn_(ColumnAnnotation astColumn) {
        ColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    private ColumnAnnotation buildNullColumn() {
        return new EclipseLinkNullWriteTransformerColumnAnnotation(this);
    }

    @Override
    public TextRange getColumnTextRange() {
        if (this.column != null) {
            return this.column.getTextRange();
        }
        return this.getTextRange();
    }

    private static DeclarationAnnotationAdapter buildColumnAnnotationAdapter(DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(writeTransformerAnnotationAdapter, "column", "javax.persistence.Column");
    }

    private static ColumnAnnotation createColumn(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new SourceColumnAnnotation(parent, element, EclipseLinkSourceWriteTransformerAnnotation.buildColumnAnnotationAdapter(writeTransformerAnnotationAdapter));
    }
}

