/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public class ConstructorPattern
extends JavaSearchPattern {
    private static final char[][] REF_CATEGORIES = new char[][]{CONSTRUCTOR_REF};
    private static final char[][] REF_AND_DECL_CATEGORIES = new char[][]{CONSTRUCTOR_REF, CONSTRUCTOR_DECL};
    private static final char[][] DECL_CATEGORIES = new char[][]{CONSTRUCTOR_DECL};
    protected boolean findDeclarations = true;
    protected boolean findReferences = false;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public char[][] parameterNames;
    public int modifiers;
    private char[] fSearchPrefix;

    private ConstructorPattern(int matchRule) {
        super(32, matchRule);
    }

    public ConstructorPattern(char[] declaringQualification, char[] declaringSimpleName, int matchRule) {
        this(matchRule);
        this.declaringQualification = this.isCaseSensitive() || this.isCamelCase() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = this.isCaseSensitive() || this.isCamelCase() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
    }

    public ConstructorPattern(char[] searchPrefix, int matchRule) {
        this(matchRule);
        this.fSearchPrefix = searchPrefix;
    }

    public ConstructorPattern(char[] searchPrefix, int matchRule, boolean findDeclarations, boolean findReferences) {
        this(matchRule);
        this.fSearchPrefix = this.isCaseSensitive() || this.isCamelCase() ? searchPrefix : CharOperation.toLowerCase(searchPrefix);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[][] parameterQualifications, char[][] parameterSimpleNames, char[] declaringQualification, char[] declaringSimpleName, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterQualifications = new char[parameterSimpleNames.length][];
            this.parameterSimpleNames = new char[parameterSimpleNames.length][];
            int i = 0;
            while (i < this.parameterSimpleNames.length) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        }
        this.mustResolve = false;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new ConstructorPattern(8);
    }

    @Override
    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ConstructorPattern pattern = (ConstructorPattern)decodedPattern;
        char[][] seperatedSearchPrefix = QualificationHelpers.seperateFullyQualifedName(this.fSearchPrefix);
        return this.fSearchPrefix != null && (this.matchesName(this.fSearchPrefix, pattern.declaringQualification) || this.matchesName(this.fSearchPrefix, pattern.declaringSimpleName) || (CharOperation.equals(seperatedSearchPrefix[0], pattern.declaringQualification, this.isCaseSensitive) || ConstructorPattern.matchesQualificationPattern(seperatedSearchPrefix[0], pattern.declaringQualification, this.isCaseSensitive)) && this.matchesName(seperatedSearchPrefix[1], pattern.declaringSimpleName)) || this.fSearchPrefix == null && this.matchesName(this.declaringQualification, pattern.declaringQualification) && this.matchesName(this.declaringSimpleName, pattern.declaringSimpleName);
    }

    @Override
    EntryResult[] queryIn(Index index) throws IOException {
        char[] simpleNamePattern;
        char[] qualificationPattern;
        EntryResult[] results = null;
        if (this.fSearchPrefix != null) {
            char[][] seperatedSearchPrefix = QualificationHelpers.seperateFullyQualifedName(this.fSearchPrefix);
            qualificationPattern = seperatedSearchPrefix[0];
            simpleNamePattern = seperatedSearchPrefix[1];
        } else {
            qualificationPattern = this.declaringQualification;
            simpleNamePattern = this.declaringSimpleName;
        }
        char[][] keys = null;
        int[] matchRules = null;
        switch (this.getMatchMode()) {
            case 0: {
                keys = new char[1][];
                matchRules = new int[1];
                if (this.isCamelCase) break;
                keys[0] = qualificationPattern == null || qualificationPattern.length == 0 ? CharOperation.append(simpleNamePattern, '/') : CharOperation.concat(simpleNamePattern, qualificationPattern, '/');
                keys[0] = CharOperation.append(keys[0], '/');
                matchRules[0] = this.getMatchRule();
                matchRules[0] = matchRules[0] & 0xFFFFFFFF;
                matchRules[0] = matchRules[0] | 1;
                break;
            }
            case 1: {
                if (qualificationPattern != null && qualificationPattern.length > 0) {
                    if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                        keys = new char[1][];
                        matchRules = new int[1];
                    } else {
                        keys = new char[2][];
                        matchRules = new int[2];
                        keys[1] = simpleNamePattern;
                        matchRules[1] = this.getMatchRule();
                    }
                    char[] trimmedPrefix = this.fSearchPrefix;
                    if (this.fSearchPrefix != null && this.fSearchPrefix[this.fSearchPrefix.length - 1] == '.') {
                        trimmedPrefix = CharOperation.subarray(this.fSearchPrefix, 0, this.fSearchPrefix.length - 1);
                    }
                    keys[0] = CharOperation.concat(ONE_STAR, trimmedPrefix, '/');
                    keys[0] = CharOperation.concat(keys[0], ONE_STAR);
                    matchRules[0] = this.getMatchRule();
                    matchRules[0] = matchRules[0] & 0xFFFFFFFE;
                    matchRules[0] = matchRules[0] | 2;
                    break;
                }
                if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                    keys = new char[1][];
                    matchRules = new int[1];
                } else {
                    keys = new char[2][];
                    matchRules = new int[2];
                    keys[1] = simpleNamePattern;
                    matchRules[1] = this.getMatchRule();
                }
                keys[0] = CharOperation.concat(ONE_STAR, simpleNamePattern, '/');
                keys[0] = CharOperation.concat(keys[0], ONE_STAR);
                matchRules[0] = this.getMatchRule();
                matchRules[0] = matchRules[0] & 0xFFFFFFFE;
                matchRules[0] = matchRules[0] | 2;
                break;
            }
            case 2: {
                if (this.fSearchPrefix != null) {
                    keys = new char[2][];
                    matchRules = new int[2];
                    keys[1] = CharOperation.concat(ONE_STAR, this.fSearchPrefix, '/');
                    keys[1] = CharOperation.concat(keys[1], ONE_STAR, '/');
                    matchRules[1] = this.getMatchRule();
                } else {
                    keys = new char[1][];
                    matchRules = new int[1];
                }
                if (simpleNamePattern == null || simpleNamePattern.length == 0) {
                    simpleNamePattern = ONE_STAR;
                }
                if (qualificationPattern == null || qualificationPattern.length == 0) {
                    qualificationPattern = ONE_STAR;
                }
                keys[0] = CharOperation.concat(simpleNamePattern, qualificationPattern, '/');
                keys[0] = CharOperation.concat(keys[0], ONE_STAR, '/');
                matchRules[0] = this.getMatchRule();
                break;
            }
            case 4: {
                Logger.log(2, "Regular expression matching is not implimented by ConstructorPattern");
            }
        }
        int i = 0;
        while (i < keys.length) {
            EntryResult[] additionalResults = index.query(this.getIndexCategories(), keys[i], matchRules[i]);
            if (additionalResults != null && additionalResults.length > 0) {
                if (results == null) {
                    results = additionalResults;
                } else {
                    EntryResult[] existingResults = results;
                    results = new EntryResult[existingResults.length + additionalResults.length];
                    System.arraycopy(existingResults, 0, results, 0, existingResults.length);
                    System.arraycopy(additionalResults, 0, results, existingResults.length, additionalResults.length);
                }
            }
            ++i;
        }
        int duplicateCount = 0;
        int i2 = 0;
        while (results != null && i2 < results.length - 1) {
            int j = i2 + 1;
            while (j < results.length) {
                if (results[i2] != null && results[j] != null && CharOperation.equals(results[i2].getWord(), results[j].getWord())) {
                    results[j] = null;
                    ++duplicateCount;
                }
                ++j;
            }
            ++i2;
        }
        EntryResult[] uniqueResults = null;
        if (duplicateCount > 0) {
            uniqueResults = new EntryResult[results.length - duplicateCount];
            int uniqueIndex = 0;
            int i3 = 0;
            while (i3 < results.length) {
                if (results[i3] != null) {
                    uniqueResults[uniqueIndex] = results[i3];
                    ++uniqueIndex;
                }
                ++i3;
            }
            results = uniqueResults;
        }
        return results;
    }

    @Override
    public void decodeIndexKey(char[] key) {
        char[][] seperated = CharOperation.splitOn('/', key);
        this.declaringSimpleName = seperated[0];
        this.declaringQualification = seperated[1];
        this.parameterNames = CharOperation.splitOn(',', seperated[3]);
        char[][][] seperatedParamTypeNames = QualificationHelpers.seperateFullyQualifiedNames(seperated[2], this.parameterNames.length);
        this.parameterQualifications = seperatedParamTypeNames[0];
        this.parameterSimpleNames = seperatedParamTypeNames[1];
        this.modifiers = seperated[4][0] + seperated[4][1];
    }

    public char[] getSelector() {
        return QualificationHelpers.createFullyQualifiedName(this.declaringQualification, this.declaringSimpleName);
    }

    public char[][] getFullyQualifiedParameterTypeNames() {
        return QualificationHelpers.createFullyQualifiedNames(this.parameterQualifications, this.parameterSimpleNames);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            output.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            output.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            output.append("*");
        }
        output.append('(');
        char[][] parameterTypeNames = this.getFullyQualifiedParameterTypeNames();
        if (parameterTypeNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = parameterTypeNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (parameterTypeNames[i] != null) {
                    output.append(parameterTypeNames[i]).append('.');
                }
                ++i;
            }
        }
        output.append(')');
        return super.print(output);
    }

    public static char[] createIndexKey(char[] typeName, char[][] parameterTypes, char[][] parameterNames, int modifiers) {
        char[] parameterTypesChars = null;
        char[] parameterNamesChars = null;
        char[][] seperatedTypeName = QualificationHelpers.seperateFullyQualifedName(typeName);
        char[] qualification = seperatedTypeName[0];
        char[] simpleName = seperatedTypeName[1];
        if (parameterTypes != null) {
            parameterTypesChars = CharOperation.concatWith(parameterTypes, ',', false);
        }
        if (parameterNames != null) {
            parameterNamesChars = CharOperation.concatWith(parameterNames, ',');
        }
        int simpleNameLength = simpleName == null ? 0 : simpleName.length;
        int qualificationLength = qualification == null ? 0 : qualification.length;
        int parameterTypesLength = parameterTypesChars == null ? 0 : parameterTypesChars.length;
        int parameterNamesLength = parameterNamesChars == null ? 0 : parameterNamesChars.length;
        int resultLength = simpleNameLength + 1 + qualificationLength + 1 + parameterTypesLength + 1 + parameterNamesLength + 3;
        char[] result = new char[resultLength];
        int pos = 0;
        if (simpleNameLength > 0) {
            System.arraycopy(simpleName, 0, result, pos, simpleNameLength);
            pos += simpleNameLength;
        }
        result[pos++] = 47;
        if (qualificationLength > 0) {
            System.arraycopy(qualification, 0, result, pos, qualificationLength);
            pos += qualificationLength;
        }
        result[pos++] = 47;
        if (parameterTypesLength > 0) {
            System.arraycopy(parameterTypesChars, 0, result, pos, parameterTypesLength);
            pos += parameterTypesLength;
        }
        result[pos++] = 47;
        if (parameterNamesLength > 0) {
            System.arraycopy(parameterNamesChars, 0, result, pos, parameterNamesLength);
            pos += parameterNamesLength;
        }
        result[pos++] = 47;
        result[pos++] = (char)modifiers;
        result[pos++] = (char)(modifiers >> 16);
        return result;
    }

    public char[] getSearchPrefix() {
        return this.fSearchPrefix;
    }
}

