/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.internal.model.StylesheetParser;
import org.eclipse.wst.xsl.core.model.Stylesheet;

public class StylesheetBuilder {
    private static StylesheetBuilder instance;
    private final Map<IFile, Stylesheet> builtFiles = new HashMap<IFile, Stylesheet>();

    private StylesheetBuilder() {
    }

    public Stylesheet getStylesheet(IFile file, boolean force) {
        Stylesheet stylesheet = this.builtFiles.get(file);
        if (stylesheet == null || force) {
            stylesheet = this.build(file);
            this.builtFiles.put(file, stylesheet);
        }
        return stylesheet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stylesheet build(IFile file) {
        long start = System.currentTimeMillis();
        Stylesheet stylesheet = null;
        IStructuredModel smodel = null;
        try {
            try {
                smodel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                if (smodel == null) {
                    smodel = StructuredModelManager.getModelManager().getModelForRead(file);
                }
                if (smodel == null || !(smodel instanceof IDOMModel)) return stylesheet;
                IDOMModel model = (IDOMModel)smodel;
                stylesheet = this.parseModel(model, file);
                return stylesheet;
            }
            catch (IOException e) {
                XSLCorePlugin.log(e);
                if (smodel == null) return stylesheet;
                smodel.releaseFromRead();
                return stylesheet;
            }
            catch (CoreException e) {
                XSLCorePlugin.log(e);
                if (smodel == null) return stylesheet;
                smodel.releaseFromRead();
                return stylesheet;
            }
        }
        finally {
            if (smodel != null) {
                smodel.releaseFromRead();
            }
        }
    }

    private Stylesheet parseModel(IDOMModel model, IFile file) {
        IDOMDocument document = model.getDocument();
        Stylesheet sf = new Stylesheet(file);
        StylesheetParser walker = new StylesheetParser(sf);
        walker.walkDocument(document);
        return sf;
    }

    public static synchronized StylesheetBuilder getInstance() {
        if (instance == null) {
            instance = new StylesheetBuilder();
        }
        return instance;
    }

    public void release() {
        if (this.builtFiles.isEmpty()) {
            return;
        }
        Iterator<IFile> it = this.builtFiles.keySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public void release(IFile file) {
        this.builtFiles.remove(file);
    }
}

