/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMByteClassBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMByteClassBeanTypeProxy
extends REMAbstractNumberBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;
    private final INumberBeanProxy oneProxy;
    private final INumberBeanProxy twoProxy;
    private final INumberBeanProxy threeProxy;

    REMByteClassBeanTypeProxy(REMProxyFactoryRegistry aRegistry, IBeanTypeProxy numberType) {
        super(aRegistry, new Integer(6), Byte.class.getName(), numberType);
        this.zeroProxy = new REMByteClassBeanProxy(aRegistry, new Byte(0));
        this.oneProxy = new REMByteClassBeanProxy(aRegistry, new Byte(1));
        this.twoProxy = new REMByteClassBeanProxy(aRegistry, new Byte(2));
        this.threeProxy = new REMByteClassBeanProxy(aRegistry, new Byte(3));
    }

    INumberBeanProxy createByteBeanProxy(Byte aByte) {
        switch (aByte) {
            case 0: {
                return this.zeroProxy;
            }
            case 1: {
                return this.oneProxy;
            }
            case 2: {
                return this.twoProxy;
            }
            case 3: {
                return this.threeProxy;
            }
        }
        return new REMByteClassBeanProxy(this.fRegistry, aByte);
    }

    @Override
    protected INumberBeanProxy createNumberBeanProxy(Number aNumber) {
        return this.createByteBeanProxy((Byte)aNumber);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createByteBeanProxy(new Byte(value.aByte));
    }
}

