/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.jst.j2ee.internal.ui.DoubleCheckboxTableItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DoubleCheckboxTableViewer
extends CheckboxTableViewer {
    protected int mSecondCheckboxColumnIndex;
    protected ICheckStateListener lstnr = null;

    public DoubleCheckboxTableViewer(Table table, int secondCheckBoxColumnIndex) {
        super(table);
        if (secondCheckBoxColumnIndex < 1) {
            throw new IllegalArgumentException("The index of the second column with check box must be bigger than zero");
        }
        this.mSecondCheckboxColumnIndex = secondCheckBoxColumnIndex;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        super.addCheckStateListener(listener);
        this.lstnr = listener;
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        super.removeCheckStateListener(listener);
        this.lstnr = null;
        this.getTable().getItems();
        int i = 0;
        while (i < this.getTable().getItems().length) {
            DoubleCheckboxTableItem it = (DoubleCheckboxTableItem)this.getTable().getItem(i);
            it.setTableListener(null);
            ++i;
        }
    }

    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        DoubleCheckboxTableItem item = rowIndex >= 0 ? new DoubleCheckboxTableItem(this.getTable(), style, rowIndex, this.mSecondCheckboxColumnIndex, this) : new DoubleCheckboxTableItem(this.getTable(), style, this.mSecondCheckboxColumnIndex, this);
        item.setTableListener(this.lstnr);
        TableEditor editor = new TableEditor(this.getTable());
        editor.minimumWidth = item.getSecondCheckBox().getSize().x;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)item.getSecondCheckBox(), (TableItem)item, this.mSecondCheckboxColumnIndex);
        return this.getViewerRowFromItem((Widget)item);
    }

    public Object[] getSecondCheckedItems() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<DoubleCheckboxTableItem> v = new ArrayList<DoubleCheckboxTableItem>(children.length);
        int i = 0;
        while (i < children.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)children[i];
            if (item.getSecondChecked()) {
                v.add(item);
            }
            ++i;
        }
        return v.toArray();
    }

    public void setAllSecondChecked(boolean state) {
        TableItem[] children = this.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)children[i];
            item.setSecondChecked(state);
            ++i;
        }
    }

    public Object[] getSingleCheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)children[i];
            if (item.getChecked() && !item.getSecondChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public Object[] getDoubleCheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)children[i];
            if (item.getChecked() && item.getSecondChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public Object[] getUncheckedItems() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<TableItem> v = new ArrayList<TableItem>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (!item.getChecked()) {
                v.add(item);
            }
            ++i;
        }
        return v.toArray();
    }

    public Object[] getSecondUncheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)children[i];
            if (!item.getSecondChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public void setSecondCheckedItems(Object[] inputItems) {
        this.assertElementsNotNull(inputItems);
        Hashtable<Object, Object> set = new Hashtable<Object, Object>();
        int i = 0;
        while (i < inputItems.length) {
            set.put(inputItems[i], inputItems[i]);
            ++i;
        }
        TableItem[] items = this.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            DoubleCheckboxTableItem item = (DoubleCheckboxTableItem)items[i2];
            boolean check = set.containsKey((Object)item);
            if (item.getSecondChecked() != check) {
                item.setSecondChecked(check);
            }
            ++i2;
        }
    }

    protected void doRemove(int start, int end) {
        int i = start;
        while (i <= end) {
            this.disposeSecondCheckboxOfItem(i);
            ++i;
        }
        super.doRemove(start, end);
    }

    protected void doRemove(int[] indices) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.disposeSecondCheckboxOfItem(i);
            ++n2;
        }
        super.doRemove(indices);
    }

    private void disposeSecondCheckboxOfItem(int index) {
        TableItem item = this.getTable().getItem(index);
        if (item instanceof DoubleCheckboxTableItem) {
            ((DoubleCheckboxTableItem)item).disposeSecondCheckbox();
        }
    }
}

