/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RawNominalType
extends Namespace {
    private final Node defSite;
    private boolean isFinalized;
    private PersistentMap<String, Property> classProps = PersistentMap.create();
    private PersistentMap<String, Property> protoProps = PersistentMap.create();
    private PersistentMap<String, Property> randomProps = PersistentMap.create();
    private NominalType superClass = null;
    private ImmutableSet<NominalType> interfaces = null;
    private final Kind kind;
    private ImmutableSet<String> allProps = null;
    private final NominalType wrappedAsNominal;
    private final JSType wrappedAsJSType;
    private final JSType wrappedAsNullableJSType;
    private final ImmutableList<String> typeParameters;
    private ObjectKind objectKind;
    private FunctionType ctorFn;

    private RawNominalType(Node defSite, String name, ImmutableList<String> typeParameters, Kind kind, ObjectKind objectKind) {
        Preconditions.checkNotNull((Object)objectKind);
        Preconditions.checkState((defSite == null || defSite.isFunction() || defSite.isCall() ? 1 : 0) != 0, (String)"Expected function or call but found %s", (Object[])new Object[]{Token.name(defSite.getType())});
        if (typeParameters == null) {
            typeParameters = ImmutableList.of();
        }
        this.name = name;
        this.defSite = defSite;
        this.typeParameters = typeParameters;
        this.kind = kind;
        this.objectKind = RawNominalType.isBuiltinHelper(name, "IObject", defSite) ? ObjectKind.UNRESTRICTED : objectKind;
        this.wrappedAsNominal = new NominalType((ImmutableMap<String, JSType>)ImmutableMap.of(), this);
        ObjectType objInstance = RawNominalType.isBuiltinHelper(name, "Function", defSite) ? ObjectType.fromFunction(FunctionType.TOP_FUNCTION, this.wrappedAsNominal) : (RawNominalType.isBuiltinHelper(name, "Object", defSite) ? ObjectType.TOP_OBJECT : ObjectType.fromNominalType(this.wrappedAsNominal));
        this.wrappedAsJSType = JSType.fromObjectType(objInstance);
        this.wrappedAsNullableJSType = JSType.join(JSType.NULL, this.wrappedAsJSType);
    }

    public static RawNominalType makeUnrestrictedClass(Node defSite, String name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name, typeParameters, Kind.CLASS, ObjectKind.UNRESTRICTED);
    }

    public static RawNominalType makeStructClass(Node defSite, String name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name, typeParameters, Kind.CLASS, ObjectKind.STRUCT);
    }

    public static RawNominalType makeDictClass(Node defSite, String name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name, typeParameters, Kind.CLASS, ObjectKind.DICT);
    }

    public static RawNominalType makeNominalInterface(Node defSite, String name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name, typeParameters, Kind.INTERFACE, ObjectKind.STRUCT);
    }

    public static RawNominalType makeStructuralInterface(Node defSite, String name, ImmutableList<String> typeParameters) {
        return new RawNominalType(defSite, name, typeParameters, Kind.RECORD, ObjectKind.STRUCT);
    }

    public Node getDefSite() {
        return this.defSite;
    }

    private static boolean isBuiltinHelper(String nameToCheck, String builtinName, Node defSite) {
        return defSite != null && defSite.isFromExterns() && nameToCheck.equals(builtinName);
    }

    boolean isBuiltinWithName(String s) {
        return RawNominalType.isBuiltinHelper(this.name, s, this.defSite);
    }

    public boolean isClass() {
        return this.kind == Kind.CLASS;
    }

    public boolean isInterface() {
        return this.kind != Kind.CLASS;
    }

    boolean isStructuralInterface() {
        return this.kind == Kind.RECORD;
    }

    boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public boolean isStruct() {
        Preconditions.checkState((this.isFinalized() || this.isClass() ? 1 : 0) != 0);
        return this.objectKind.isStruct();
    }

    public boolean isDict() {
        return this.objectKind.isDict();
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    ImmutableList<String> getTypeParameters() {
        return this.typeParameters;
    }

    ObjectKind getObjectKind() {
        return this.objectKind;
    }

    public FunctionType getConstructorFunction() {
        return this.ctorFn;
    }

    public void setCtorFunction(FunctionType ctorFn) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        this.ctorFn = ctorFn;
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isClass());
        if (this == ancestor) {
            return true;
        }
        if (this.superClass == null) {
            return false;
        }
        return this.superClass.hasAncestorClass(ancestor);
    }

    public boolean addSuperClass(NominalType superClass) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        Preconditions.checkState((this.superClass == null ? 1 : 0) != 0);
        if (superClass.hasAncestorClass(this)) {
            return false;
        }
        this.superClass = superClass;
        return true;
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        Preconditions.checkState((boolean)ancestor.isInterface());
        if (this == ancestor) {
            return true;
        }
        if (this.interfaces == null) {
            return false;
        }
        for (NominalType superInter : this.interfaces) {
            if (!superInter.hasAncestorInterface(ancestor)) continue;
            return true;
        }
        return false;
    }

    private boolean inheritsFromIObject() {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (this.isBuiltinWithName("IObject")) {
            return true;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                if (!interf.getRawNominalType().inheritsFromIObject()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean addInterfaces(ImmutableSet<NominalType> interfaces) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        Preconditions.checkState((this.interfaces == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(interfaces);
        if (this.isInterface()) {
            for (NominalType interf : interfaces) {
                if (!interf.hasAncestorInterface(this)) continue;
                this.interfaces = ImmutableSet.of();
                return false;
            }
        }
        for (NominalType interf : interfaces) {
            if (!interf.getRawNominalType().inheritsFromIObject()) continue;
            this.objectKind = ObjectKind.UNRESTRICTED;
        }
        this.interfaces = interfaces;
        return true;
    }

    public NominalType getSuperClass() {
        return this.superClass;
    }

    public ImmutableSet<NominalType> getInterfaces() {
        return this.interfaces == null ? ImmutableSet.of() : this.interfaces;
    }

    private Property getOwnProp(String pname) {
        Property p = (Property)this.classProps.get(pname);
        if (p != null) {
            return p;
        }
        p = (Property)this.randomProps.get(pname);
        if (p != null) {
            return p;
        }
        return (Property)this.protoProps.get(pname);
    }

    private Property getPropFromClass(String pname) {
        Preconditions.checkState((boolean)this.isClass());
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.superClass != null && (p = this.superClass.getProp(pname)) != null) {
            return p;
        }
        return null;
    }

    private Property getPropFromInterface(String pname) {
        Preconditions.checkState((boolean)this.isInterface());
        Property p = this.getOwnProp(pname);
        if (p != null) {
            return p;
        }
        if (this.interfaces != null) {
            for (NominalType interf : this.interfaces) {
                p = interf.getProp(pname);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    Property getProp(String pname) {
        if (this.isInterface()) {
            return this.getPropFromInterface(pname);
        }
        return this.getPropFromClass(pname);
    }

    public boolean mayHaveOwnProp(String pname) {
        return this.getOwnProp(pname) != null;
    }

    public boolean mayHaveProp(String pname) {
        return this.getProp(pname) != null;
    }

    public JSType getInstancePropDeclaredType(String pname) {
        Property p = this.getProp(pname);
        if (p == null) {
            return null;
        }
        if (p.getDeclaredType() == null && this.superClass != null) {
            return this.superClass.getPropDeclaredType(pname);
        }
        return p.getDeclaredType();
    }

    public Set<String> getAllOwnProps() {
        LinkedHashSet<String> ownProps = new LinkedHashSet<String>();
        ownProps.addAll(this.classProps.keySet());
        ownProps.addAll(this.protoProps.keySet());
        return ownProps;
    }

    ImmutableSet<String> getAllPropsOfInterface() {
        if (!this.isFinalized) {
            return null;
        }
        if (this.isClass()) {
            Preconditions.checkState((boolean)this.name.equals("Object"));
            return this.getAllPropsOfClass();
        }
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.interfaces != null) {
                for (NominalType interf : this.interfaces) {
                    builder.addAll(interf.getAllPropsOfInterface());
                }
            }
            this.allProps = builder.addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    ImmutableSet<String> getAllPropsOfClass() {
        Preconditions.checkState((boolean)this.isClass());
        Preconditions.checkState((boolean)this.isFinalized);
        if (this.allProps == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.superClass != null) {
                builder.addAll(this.superClass.getAllPropsOfClass());
            }
            this.allProps = builder.addAll(this.classProps.keySet()).addAll(this.protoProps.keySet()).build();
        }
        return this.allProps;
    }

    public void addPropertyWhichMayNotBeOnAllInstances(String pname, JSType type) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (this.classProps.containsKey(pname) || this.protoProps.containsKey(pname)) {
            return;
        }
        if (this.objectKind == ObjectKind.UNRESTRICTED) {
            this.randomProps = this.randomProps.with(pname, Property.make(type == null ? JSType.UNKNOWN : type, type));
        }
    }

    public void addClassProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        this.classProps = this.classProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        if (this.protoProps.containsKey(pname)) {
            this.addProtoProperty(pname, defSite, type, isConstant);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
    }

    public void addUndeclaredClassProperty(String pname, JSType type, Node defSite) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (this.mayHaveProp(pname)) {
            return;
        }
        this.classProps = this.classProps.with(pname, Property.makeWithDefsite(defSite, type, null));
    }

    public void addProtoProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        if (this.classProps.containsKey(pname) && ((Property)this.classProps.get(pname)).getDeclaredType() == null) {
            this.classProps = this.classProps.without(pname);
        }
        if (this.randomProps.containsKey(pname)) {
            this.randomProps = this.randomProps.without(pname);
        }
        Property newProp = isConstant ? Property.makeConstant(defSite, type, type) : (this.isStructuralInterface() && type != null && !type.isUnknown() && JSType.UNDEFINED.isSubtypeOf(type) ? Property.makeOptional(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
        this.protoProps = this.protoProps.with(pname, newProp);
    }

    public void addUndeclaredProtoProperty(String pname, Node defSite) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        if (!this.protoProps.containsKey(pname) || ((Property)this.protoProps.get(pname)).getDeclaredType() == null) {
            this.protoProps = this.protoProps.with(pname, Property.makeWithDefsite(defSite, JSType.UNKNOWN, null));
            if (this.randomProps.containsKey(pname)) {
                this.randomProps = this.randomProps.without(pname);
            }
        }
    }

    public boolean hasCtorProp(String pname) {
        return super.hasProp(pname);
    }

    public void addCtorProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        super.addProperty(pname, defSite, type, isConstant);
    }

    public void addUndeclaredCtorProperty(String pname, Node defSite) {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        super.addUndeclaredProperty(pname, defSite, JSType.UNKNOWN, false);
    }

    public JSType getCtorPropDeclaredType(String pname) {
        return super.getPropDeclaredType(pname);
    }

    public void finalize() {
        Preconditions.checkState((!this.isFinalized ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.ctorFn);
        if (this.interfaces == null) {
            this.interfaces = ImmutableSet.of();
        }
        JSType protoObject = JSType.fromObjectType(ObjectType.makeObjectType(this.superClass, this.protoProps, null, null, false, ObjectKind.UNRESTRICTED));
        this.addCtorProperty("prototype", null, protoObject, false);
        this.isFinalized = true;
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.name);
        if (!this.typeParameters.isEmpty()) {
            builder.append("<" + Joiner.on((String)",").join(this.typeParameters) + ">");
        }
        return builder;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    protected JSType computeJSType(JSTypes commonTypes) {
        Preconditions.checkState((boolean)this.isFinalized);
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        return JSType.fromObjectType(ObjectType.makeObjectType(commonTypes.getFunctionType(), null, this.ctorFn, this, this.ctorFn.isLoose(), ObjectKind.UNRESTRICTED));
    }

    public NominalType getAsNominalType() {
        return this.wrappedAsNominal;
    }

    public JSType getInstanceAsJSType() {
        return this.wrappedAsJSType;
    }

    public JSType getInstanceWithNullability(boolean includeNull) {
        return includeNull ? this.wrappedAsNullableJSType : this.wrappedAsJSType;
    }

    private static enum Kind {
        CLASS,
        INTERFACE,
        RECORD;

    }
}

