/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;

public class DelegatingCommandStack
extends CommandStack
implements CommandStackListener {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private CommandStack currentCommandStack = null;

    public CommandStack getCurrentCommandStack() {
        return this.currentCommandStack;
    }

    public void setCurrentCommandStack(CommandStack stack) {
        if (this.currentCommandStack == stack) {
            return;
        }
        if (this.currentCommandStack != null) {
            this.currentCommandStack.removeCommandStackListener((CommandStackListener)this);
        }
        this.currentCommandStack = stack;
        if (this.currentCommandStack != null) {
            this.currentCommandStack.addCommandStackListener((CommandStackListener)this);
            this.notifyListeners();
        }
    }

    public boolean canRedo() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.canRedo();
    }

    public boolean canUndo() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.canUndo();
    }

    public void dispose() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.dispose();
        }
    }

    public void execute(Command command) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.execute(command);
        }
    }

    public void flush() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.flush();
        }
    }

    public Object[] getCommands() {
        if (this.currentCommandStack == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return this.currentCommandStack.getCommands();
    }

    public Command getRedoCommand() {
        if (this.currentCommandStack == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.currentCommandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        if (this.currentCommandStack == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.currentCommandStack.getUndoCommand();
    }

    public int getUndoLimit() {
        if (this.currentCommandStack == null) {
            return -1;
        }
        return this.currentCommandStack.getUndoLimit();
    }

    public boolean isDirty() {
        if (this.currentCommandStack == null) {
            return false;
        }
        return this.currentCommandStack.isDirty();
    }

    public void markSaveLocation() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.markSaveLocation();
        }
    }

    public void redo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.redo();
        }
    }

    public void setUndoLimit(int undoLimit) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.setUndoLimit(undoLimit);
        }
    }

    public void undo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.undo();
        }
    }

    public String toString() {
        return "DelegatingCommandStack(" + this.currentCommandStack + ")";
    }

    public void commandStackChanged(EventObject event) {
        this.notifyListeners();
    }
}

