/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.jpa.annotate.internal.plugin.JptJpaAnnotatePlugin;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttribute;
import org.eclipse.jpt.jpa.annotate.mapping.BasicEntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.EntityRefPropertyElem;
import org.eclipse.jpt.jpa.annotate.mapping.IdEntityPropertyElement;
import org.eclipse.jpt.jpa.annotate.mapping.JoinStrategy;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMapper {
    private IProject _project;
    private String _fqEntityType;
    private Table _table;
    private String _pkProp;
    private List<EntityPropertyElem> _entityProperties;
    private IType _entityType;

    public JavaMapper(IProject project, String fqEntityType, Table table, String pkProp) {
        this._project = project;
        this._fqEntityType = fqEntityType;
        this._table = table;
        this._pkProp = pkProp;
        this._entityProperties = new ArrayList<EntityPropertyElem>();
        try {
            this._entityType = AnnotateMappingUtil.getType(this._fqEntityType, this._project);
        }
        catch (JavaModelException e) {
            JptJpaAnnotatePlugin.instance().logError(e);
        }
    }

    public void map() {
        try {
            IField[] fields;
            IField[] iFieldArray = fields = this._entityType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (!Flags.isStatic((int)field.getFlags()) && !Flags.isSuper((int)field.getFlags())) {
                    EntityPropertyElem entityProp;
                    if (this._pkProp != null && this._pkProp.equals(field.getElementName())) {
                        entityProp = this.mapProperty(field, true);
                        this._entityProperties.add(entityProp);
                    } else {
                        entityProp = this.mapField(field);
                        this._entityProperties.add(entityProp);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException je) {
            JptJpaAnnotatePlugin.instance().logError(je);
        }
    }

    public List<EntityPropertyElem> getEntityProperties() {
        return this._entityProperties;
    }

    private void setColumnAttrs(ColumnAttributes colAttrs, Column col) {
        colAttrs.setName(col.getName());
        colAttrs.setNullable(col.isNullable());
        colAttrs.setUnique(col.isPartOfUniqueConstraint());
        if (col.isNumeric()) {
            if (col.getPrecision() != 0) {
                colAttrs.setPrecision(col.getPrecision());
            }
            if (col.getScale() != 0) {
                colAttrs.setScale(col.getScale());
            }
        } else if (col.isTimeDataType()) {
            if (col.getPrecision() != 0) {
                colAttrs.setPrecision(col.getPrecision());
            }
        } else if (!col.isDateDataType()) {
            colAttrs.setLength(col.getLength());
        }
    }

    private EntityPropertyElem mapProperty(IField field, boolean isId) {
        try {
            EntityPropertyElem entityProp;
            String tagName;
            String propName = field.getElementName();
            String fqType = AnnotateMappingUtil.getFieldType(field, this._entityType);
            if (isId) {
                tagName = "id";
                entityProp = new IdEntityPropertyElement(this._fqEntityType, this._table, propName, fqType);
            } else {
                tagName = "basic";
                entityProp = new BasicEntityPropertyElem(this._fqEntityType, this._table, propName, fqType);
            }
            entityProp.setTagName(tagName);
            Column col = this.computeDefaultCol(propName);
            if (col != null) {
                entityProp.setDBColumn(col);
                ColumnAttributes colAttrs = new ColumnAttributes();
                this.setColumnAttrs(colAttrs, col);
                entityProp.setColumnAnnotationAttrs(colAttrs);
            }
            return entityProp;
        }
        catch (JavaModelException je) {
            JptJpaAnnotatePlugin.instance().logError(je);
            return null;
        }
    }

    private EntityPropertyElem mapOneToMany(IField field) {
        try {
            Set<String> propNames;
            IType refType;
            String type = AnnotateMappingUtil.getFieldType(field, this._entityType);
            String componentType = AnnotateMappingUtil.getGenericsComponentTypeName(type);
            if (componentType != null && this.isSimpleType(componentType = AnnotateMappingUtil.resolveType(componentType, this._entityType))) {
                return this.mapProperty(field, false);
            }
            EntityRefPropertyElem erpe = new EntityRefPropertyElem(this._fqEntityType, this._table, field.getElementName(), type);
            erpe.setTagName("one-to-many");
            erpe.setRefEntityClassName(componentType);
            if (componentType != null && (refType = AnnotateMappingUtil.getType(componentType, this._project)) != null && (propNames = AnnotateMappingUtil.getMappedByList(this._fqEntityType, refType, false)).size() == 1) {
                AnnotationAttribute attr = new AnnotationAttribute("mappedBy", propNames.iterator().next());
                erpe.setAnnotationAttr(attr);
                erpe.setJoinStrategy(JoinStrategy.MAPPED_BY);
            }
            return erpe;
        }
        catch (JavaModelException e) {
            JptJpaAnnotatePlugin.instance().logError(e);
            return null;
        }
    }

    private EntityPropertyElem mapManyToOne(IField field) {
        try {
            String fqType = AnnotateMappingUtil.getFieldType(field, this._entityType);
            EntityRefPropertyElem erpe = new EntityRefPropertyElem(this._fqEntityType, this._table, field.getElementName(), fqType);
            erpe.setTagName("many-to-one");
            erpe.setRefEntityClassName(AnnotateMappingUtil.getFieldType(field, this._entityType));
            erpe.setJoinStrategy(JoinStrategy.JOIN_COLUMNS);
            return erpe;
        }
        catch (JavaModelException je) {
            JptJpaAnnotatePlugin.instance().logError(je);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EntityPropertyElem mapField(IField field) {
        try {
            boolean isSimpleProperty;
            String type = AnnotateMappingUtil.getFieldType(field, this._entityType);
            if (AnnotateMappingUtil.isRepeatingType(type, this._project)) {
                if (!AnnotateMappingUtil.isArrayType(type) || !AnnotateMappingUtil.stripArrayDimensions(type).equals("byte")) return this.mapOneToMany(field);
                isSimpleProperty = true;
            } else {
                isSimpleProperty = this.isSimpleType(type);
            }
            if (!isSimpleProperty) return this.mapManyToOne(field);
            return this.mapProperty(field, false);
        }
        catch (JavaModelException je) {
            JptJpaAnnotatePlugin.instance().logError(je);
            return null;
        }
    }

    private Column computeDefaultCol(String propName) {
        for (Column col : this._table.getColumns()) {
            String colName = col.getName();
            if (!propName.equalsIgnoreCase(colName) && !propName.equalsIgnoreCase(AnnotateMappingUtil.dbNameToJavaName(colName))) continue;
            return col;
        }
        return null;
    }

    private boolean isSimpleType(String type) {
        boolean isSimpleType = ClassNameTools.isPrimitive((String)type) || ClassNameTools.isPrimitiveWrapper((String)type) || type.startsWith("java.");
        return isSimpleType;
    }
}

