/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CreateItemCommand;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationRequest;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.DropCustomizationController;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class PDTemplateTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public PDTemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TemplateTransfer.getInstance());
    }

    protected Request createTargetRequest() {
        ItemCreationRequest request = new ItemCreationRequest();
        TemplateTransfer.getInstance().getTemplate();
        return request;
    }

    protected final Request getCreateRequest() {
        return this.getTargetRequest();
    }

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    protected void updateTargetRequest() {
        if (this.getCreateRequest() instanceof ItemCreationRequest) {
            ItemCreationRequest request = (ItemCreationRequest)this.getCreateRequest();
            Object transferObj = TemplateTransfer.getInstance().getObject();
            if (transferObj instanceof IDropSourceData) {
                request.setTagCreationProvider((IDropSourceData)transferObj);
                request.setLocation(this.getDropLocation());
            } else {
                PDPlugin.getLogger(((Object)((Object)this)).getClass()).error("Unexpected transfer object on palette drag:" + transferObj, new Throwable("Artificial throwable for stack tracing"));
            }
        }
    }

    public void drop(DropTargetEvent event) {
        if (this.getCreateRequest() instanceof ItemCreationRequest) {
            this.getViewer().getControl().setFocus();
            super.drop(event);
        }
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                if (this.customizeAndCheckExecute(command)) {
                    this.getViewer().getEditDomain().getCommandStack().execute(command);
                } else {
                    this.getCurrentEvent().detail = 0;
                }
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
    }

    private boolean customizeAndCheckExecute(Command command) {
        if (command instanceof CreateItemCommand) {
            CreateItemCommand createCommand = (CreateItemCommand)command;
            ItemCreationRequest request = (ItemCreationRequest)this.getCreateRequest();
            IStatus status = new DropCustomizationController(createCommand, request.getTagCreationProvider(), createCommand.getDocument(), createCommand.getPosition()).performCustomization();
            return status.getSeverity() == 0;
        }
        return true;
    }
}

