/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.osgi.util.NLS;

public class ExternalDebugLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)GenericServerCoreMessages.attachingToExternalGenericServer, (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(GenericServerCoreMessages.verifyingExternalServerDebuggingLaunchAttributes);
        String connectorId = this.getVMConnectorId(configuration);
        IVMConnector connector = null;
        connector = connectorId == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)connectorId);
        if (connector == null) {
            this.abort(GenericServerCoreMessages.externalServerDebugConnectorNotSpecified, null, 119);
        }
        Map argMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        argMap.put("timeout", "" + connectTimeout);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(GenericServerCoreMessages.creatingExternalServerDebuggingSourceLocator);
        this.setDefaultSourceLocator(launch, configuration);
        monitor.worked(1);
        connector.connect(argMap, monitor, launch);
        if (monitor.isCanceled()) {
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget target = debugTargets[i];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++i;
            }
            return;
        }
        monitor.done();
    }
}

