/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.AnyObjectBased;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtype;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.MethodHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ObjectData;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.TypeHandler;
import org.json.simple.JSONObject;

class BaseHandlersLibrary {
    public static BaseHandlersLibrary INSTANCE;
    private final Map<Method, MethodHandler> method2Handler = new HashMap<Method, MethodHandler>();
    static final Method[] OBJECT_METHODS;

    static {
        try {
            OBJECT_METHODS = new Method[]{Object.class.getMethod("equals", Object.class), Object.class.getMethod("hashCode", new Class[0]), Object.class.getMethod("toString", new Class[0])};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            INSTANCE = new BaseHandlersLibrary(OBJECT_METHODS);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Method, ? extends MethodHandler> getAllHandlers() {
        return this.method2Handler;
    }

    public static void writeBaseMethodsJava(JavaCodeGenerator.ClassScope scope, TypeHandler<?> typeHandler) {
        block3: {
            Method method;
            Class<?> typeClass = typeHandler.getTypeClass();
            try {
                method = typeClass.getMethod("getUnderlyingObject", new Class[0]);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                break block3;
            }
            MethodHandler.writeMethodDeclarationJava(scope, method, Collections.<String>emptyList());
            scope.startLine("{\n");
            scope.startLine("  return underlying;\n");
            scope.startLine("}\n");
        }
        typeHandler.getSubtypeSupport().writeGetSuperMethodJava(scope);
    }

    private BaseHandlersLibrary(Method[] objectMethods) throws NoSuchMethodException {
        Method[] methodArray = objectMethods;
        int n = objectMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            this.method2Handler.put(m, new SelfCallMethodHanlder(m));
            ++n2;
        }
        BaseHandlersLibrary.fill(this.method2Handler, new GetJsonObjectMethodHaldler(), new GetAnyObjectMethodHaldler(), new GetSuperMethodHaldler());
    }

    private static void fill(Map<Method, MethodHandler> map, MethodHandlerBase ... handlers) {
        MethodHandlerBase[] methodHandlerBaseArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            MethodHandlerBase handler = methodHandlerBaseArray[n2];
            map.put(handler.getMethod(), handler);
            ++n2;
        }
    }

    private static class GetAnyObjectMethodHaldler
    extends MethodHandlerBase {
        GetAnyObjectMethodHaldler() throws NoSuchMethodException {
            super(AnyObjectBased.class.getMethod("getUnderlyingObject", new Class[0]));
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) {
            return objectData.getUnderlyingObject();
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
        }
    }

    private static class GetJsonObjectMethodHaldler
    extends MethodHandlerBase {
        GetJsonObjectMethodHaldler() throws NoSuchMethodException {
            super(JsonObjectBased.class.getMethod("getUnderlyingObject", new Class[0]));
        }

        JSONObject handle(ObjectData objectData, Object[] args) {
            return (JSONObject)objectData.getUnderlyingObject();
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
        }
    }

    private static class GetSuperMethodHaldler
    extends MethodHandlerBase {
        GetSuperMethodHaldler() throws NoSuchMethodException {
            super(JsonSubtype.class.getMethod("getSuper", new Class[0]));
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) {
            return objectData.getSuperObjectData().getProxy();
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
        }
    }

    private static abstract class MethodHandlerBase
    extends MethodHandler {
        private final Method method;

        MethodHandlerBase(Method method) {
            this.method = method;
        }

        Method getMethod() {
            return this.method;
        }
    }

    private static class SelfCallMethodHanlder
    extends MethodHandlerBase {
        SelfCallMethodHanlder(Method method) {
            super(method);
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return this.getMethod().invoke((Object)objectData, args);
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
        }
    }
}

