/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model.component;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.AbstractVisitor;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTreeVisitor;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.IVisitable;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.FacetDecorator;

public class ComponentInfo
extends ViewObject
implements Serializable,
IVisitable {
    private static final long serialVersionUID = 2517204356825585699L;
    private static final int DEFAULT_ARRAY_SIZE = 4;
    private transient BeanPropertyManager _beanPropertyManager;
    protected final ComponentInfoData _data;

    protected ComponentInfo(String id, ComponentInfo parent, ComponentTypeInfo componentTypeInfo, boolean isRendered) {
        super(new ComponentInfoData(id, parent, componentTypeInfo, isRendered));
        this._data = (ComponentInfoData)super.getData();
        HashSet<String> propExclude = new HashSet<String>();
        propExclude.add("attributeNames");
        propExclude.add("componentTypeInfo");
        propExclude.add("valueChangeListeners");
        propExclude.add("visitableChildren");
        this._beanPropertyManager = new BeanPropertyManager(this, propExclude);
    }

    protected ComponentInfo(ComponentInfoData data) {
        super(data);
        this._data = data;
    }

    protected ComponentInfo(ComponentInfo parent, ComponentTypeInfo componentTypeInfo, Map attributes) {
        this(ComponentInfo.getStringProperty("id", attributes, false), parent, componentTypeInfo, ComponentInfo.getBooleanProperty("rendered", attributes, false));
    }

    protected static String getStringProperty(String key, Map attributes, boolean mandatory) {
        Object value = attributes.get(key);
        if (mandatory && value == null) {
            throw new IllegalArgumentException(String.valueOf(key) + " is a mandatory attribute");
        }
        return (String)value;
    }

    protected static boolean getBooleanProperty(String key, Map attributes, boolean mandatory) {
        Boolean value = (Boolean)attributes.get(key);
        if (value == null) {
            if (mandatory) {
                throw new IllegalArgumentException(String.valueOf(key) + "is mandatory");
            }
            return false;
        }
        return value;
    }

    protected static int getIntegerProperty(String key, Map attributes) {
        Number value = (Number)attributes.get(key);
        if (value == null) {
            return 0;
        }
        return value.intValue();
    }

    protected static ComponentInfo getComponentProperty(String key, Map attributes) {
        return (ComponentInfo)attributes.get(key);
    }

    public final String getId() {
        return this._data.getId();
    }

    public final ComponentTypeInfo getComponentTypeInfo() {
        return this._data.getComponentTypeInfo();
    }

    protected final void clearChildren() {
        this._data.getChildren().clear();
    }

    public final List getChildren() {
        if (this._data.isProtected()) {
            return this._data.getChildren();
        }
        return Collections.unmodifiableList(this._data.getChildren());
    }

    public final List getFacets() {
        return this.getDecorators(ComponentFactory.FACET);
    }

    public final void addChild(ComponentInfo childComponent) {
        if (childComponent == this) {
            throw new IllegalArgumentException("A component cannot be its own child");
        }
        this._data.addChild(childComponent);
        childComponent.setParent(this);
    }

    public final void setParent(ComponentInfo parent) {
        this._data.setParent(parent);
    }

    public final void addFacet(String name, ComponentInfo facetComponent) {
        this.addChild(facetComponent);
        this.addDecorator(new FacetDecorator(name, facetComponent));
    }

    public final String getFacetName(ComponentInfo component) {
        if (component == null) {
            return null;
        }
        List facets = this.getDecorators(ComponentFactory.FACET);
        for (FacetDecorator facet : facets) {
            if (component != facet.getDecorates()) continue;
            return facet.getName();
        }
        return null;
    }

    public final ComponentInfo getFacet(String name) {
        if (name == null) {
            return null;
        }
        List facets = this.getDecorators(ComponentFactory.FACET);
        for (FacetDecorator facet : facets) {
            if (!name.equals(facet.getName())) continue;
            return facet.getDecorates();
        }
        return null;
    }

    public String toString() {
        String parentId = this.getParent() != null ? this.getParent().getId() : "null";
        String toString = String.valueOf(this.getMostSpecificComponentName()) + ": id=" + this._data.getId() + ", parentId: " + parentId + ", family=" + this.getComponentTypeInfo().getComponentFamily() + ", render=" + this.getComponentTypeInfo().getRenderFamily() + ", rendered=" + this.isRendered();
        if (this.getClass() != ComponentInfo.class) {
            toString = String.valueOf(toString) + this.dumpProperties();
        }
        return toString;
    }

    private String dumpProperties() {
        String properties = "";
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass(), ComponentInfo.class);
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                PropertyDescriptor desc = descriptors[i];
                String name = desc.getName();
                Object valueObj = desc.getValue(name);
                String value = valueObj != null ? valueObj.toString() : "null";
                properties = String.valueOf(properties) + ", " + name + "=" + value;
                ++i;
            }
        }
        catch (IntrospectionException e) {
            return "Error introspecting bean: " + e.getLocalizedMessage();
        }
        return properties;
    }

    protected String getMostSpecificComponentName() {
        return "UIComponent";
    }

    public final ComponentInfo getParent() {
        return this._data.getParent();
    }

    public final boolean isRendered() {
        return this._data.isRendered();
    }

    @Override
    public synchronized void addAdapter(Class adapterType, Object adapter) {
        super.addAdapter(adapterType, adapter);
        this._beanPropertyManager.reset();
    }

    @Override
    public synchronized Object removeAdapter(Class adapterType) {
        Object removed = super.removeAdapter(adapterType);
        this._beanPropertyManager.reset();
        return removed;
    }

    protected final Map getBeanProperties() {
        return Collections.unmodifiableMap(this._beanPropertyManager.getBeanProperties());
    }

    public synchronized ComponentBeanProperty getAttribute(String name) {
        return (ComponentBeanProperty)this.getBeanProperties().get(name);
    }

    public synchronized Set getAttributeNames() {
        return this.getBeanProperties().keySet();
    }

    public final void setSubtreeProtected() {
        ComponentTreeVisitor protectionVisitor = new ComponentTreeVisitor(AbstractVisitor.VisitationPolicy.ChildrenFirstPolicy){

            @Override
            public void visit(ComponentInfo component) {
                component.setProtected();
            }
        };
        this.accept(protectionVisitor);
    }

    @Override
    public void accept(AbstractVisitor visitor) {
        if (visitor.getPolicy().getOrdering() == 0) {
            visitor.visit(this);
            this.visitChildren(visitor);
        } else {
            this.visitChildren(visitor);
            visitor.visit(this);
        }
    }

    private void visitChildren(AbstractVisitor visitor) {
        Iterator it = this.getVisitableChildren();
        while (it.hasNext()) {
            visitor.visit(it.next());
        }
    }

    @Override
    public Iterator getVisitableChildren() {
        return this.getChildren().iterator();
    }

    protected static final class BeanPropertyManager {
        protected transient Map _beanProperties;
        private final transient ComponentInfo _component;
        private final transient Set _excludeNames;
        private static transient Map PROPERTY_MAP = new HashMap();

        protected BeanPropertyManager(ComponentInfo component, Set excludeNames) {
            this._component = component;
            this._excludeNames = excludeNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getBeanProperties() {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException("Must not already own this lock");
            }
            ComponentInfo componentInfo = this._component;
            synchronized (componentInfo) {
                BeanPropertyManager beanPropertyManager = this;
                synchronized (beanPropertyManager) {
                    if (this._beanProperties == null) {
                        this._beanProperties = this.calculateAllBeanPropNames(ViewObject.class);
                    }
                    return this._beanProperties;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException("Must not already own this lock");
            }
            ComponentInfo componentInfo = this._component;
            synchronized (componentInfo) {
                BeanPropertyManager beanPropertyManager = this;
                synchronized (beanPropertyManager) {
                    if (this._beanProperties != null) {
                        this._beanProperties.clear();
                        this._beanProperties = null;
                    }
                }
            }
        }

        private Map calculateAllBeanPropNames(Class stopClass) {
            HashMap allProperties = new HashMap();
            Class<?> myClass = this._component.getClass();
            List myProperties = BeanPropertyManager.getOrCreateBeanProperties(myClass, stopClass);
            BeanPropertyManager.addToMap(myProperties, this._component, myClass, allProperties, this._excludeNames);
            for (Map.Entry entry : this._component.getAdapterMap().entrySet()) {
                Class adapterClass = (Class)entry.getKey();
                Object declaringClass = entry.getValue();
                List props = BeanPropertyManager.getOrCreateBeanProperties(adapterClass, null);
                BeanPropertyManager.addToMap(props, declaringClass, adapterClass, allProperties, this._excludeNames);
            }
            return Collections.synchronizedMap(allProperties);
        }

        private static void addToMap(List addThese, Object declaringObject, Class declaringAdapter, Map toMe, Set excludeNames) {
            for (PropertyDescriptor desc : addThese) {
                if (toMe.containsKey(desc.getName()) || excludeNames.contains(desc.getName())) continue;
                toMe.put(desc.getName(), new ComponentBeanProperty(declaringAdapter, declaringObject, desc));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static List getOrCreateBeanProperties(Class startClass, Class stopClass) {
            Map map = PROPERTY_MAP;
            synchronized (map) {
                List localBeanProps = (List)PROPERTY_MAP.get(startClass);
                if (localBeanProps == null) {
                    localBeanProps = BeanPropertyManager.calculateBeanProperties(startClass, stopClass);
                    PROPERTY_MAP.put(startClass, Collections.unmodifiableList(localBeanProps));
                }
                return localBeanProps;
            }
        }

        private static List calculateBeanProperties(Class startClass, Class stopClass) {
            List<Object> names = new ArrayList();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(startClass, stopClass);
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    names = Arrays.asList(descriptors);
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            return names;
        }
    }

    public static final class ComponentBeanProperty {
        private final PropertyDescriptor _propertyDescriptor;
        private final Object _declaringImplementation;
        private final Class _adapterKeyClass;

        private ComponentBeanProperty(Class adapterKeyClass, Object declaringImplementationClass, PropertyDescriptor propertyDescriptor) {
            this._adapterKeyClass = adapterKeyClass;
            this._declaringImplementation = declaringImplementationClass;
            this._propertyDescriptor = propertyDescriptor;
        }

        public final Object getValue() {
            Method method = this._propertyDescriptor.getReadMethod();
            if (method != null) {
                try {
                    method.setAccessible(true);
                    return method.invoke(this._declaringImplementation, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public final PropertyDescriptor getPropertyDescriptor() {
            return this._propertyDescriptor;
        }

        public final Object getDeclaringImplementationClass() {
            return this._declaringImplementation;
        }

        public final Class getAdapterKeyClass() {
            return this._adapterKeyClass;
        }
    }

    public static class ComponentInfoData
    extends ViewObject.ViewObjectData {
        private static final long serialVersionUID = 5052732412917986062L;
        private final String _id;
        private ComponentInfo _parent;
        protected final ComponentTypeInfo _componentTypeInfo;
        protected final boolean _isRendered;
        private List _children = new ArrayList(4);

        public ComponentInfoData(String id, ComponentInfo parent, ComponentTypeInfo componentTypeInfo, boolean isRendered) {
            super(false);
            this._id = id;
            this._parent = parent;
            this._componentTypeInfo = componentTypeInfo;
            this._isRendered = isRendered;
        }

        protected void addChild(ComponentInfo childComponent) {
            this.enforceProtection();
            this.getChildren().add(childComponent);
        }

        protected final List getChildren() {
            return this._children;
        }

        @Override
        protected void doBeforeProtecting() {
            super.doBeforeProtecting();
            this._children = this._children.size() > 0 ? Collections.unmodifiableList(this._children) : Collections.EMPTY_LIST;
        }

        protected final boolean isRendered() {
            return this._isRendered;
        }

        protected final ComponentTypeInfo getComponentTypeInfo() {
            return this._componentTypeInfo;
        }

        protected final ComponentInfo getParent() {
            return this._parent;
        }

        protected final void setParent(ComponentInfo parent) {
            this.enforceProtection();
            this._parent = parent;
        }

        protected final String getId() {
            return this._id;
        }
    }
}

