/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.util.MetadataResourceImpl;

public class StandardModelFactory {
    private static StandardModelFactory INSTANCE;
    static boolean DEBUG_MD_LOAD;
    static boolean DEBUG_MD_GET;
    private ExtendedMetaData extendedMetaData;
    private ResourceSet resourceSet;

    static {
        DEBUG_MD_LOAD = false;
        DEBUG_MD_GET = false;
    }

    public static synchronized StandardModelFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StandardModelFactory();
            INSTANCE.init();
            if (JSFCommonPlugin.getPlugin().isDebugging()) {
                DEBUG_MD_LOAD = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsf.common/debug/metadataload"));
                DEBUG_MD_GET = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsf.common/debug/metadataget"));
            }
        }
        return INSTANCE;
    }

    private void init() {
        this.resourceSet = new ResourceSetImpl();
        this.extendedMetaData = new BasicExtendedMetaData(this.resourceSet.getPackageRegistry());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
    }

    private StandardModelFactory() {
    }

    public MetaDataModel createModel(IMetaDataModelContext context, IDomainLoadingStrategy strategy) {
        return new MetaDataModel(context, strategy);
    }

    public EList loadStandardFileResource(InputStream inputStream, IMetaDataSourceModelProvider provider, URI uri) throws IOException {
        MetadataResourceImpl res = new MetadataResourceImpl(provider);
        StandardModelFactory.debug(String.format(">>> Loading standard meta-data file for uri %s", uri), DEBUG_MD_LOAD);
        res.setURI(uri);
        this.resourceSet.getResources().add((Object)res);
        this.setLoadOptions((XMLResource)res);
        res.load(inputStream, null);
        if (DEBUG_MD_LOAD) {
            this.reportErrors((Resource)res);
        }
        EList root = res.getContents();
        return root;
    }

    private void reportErrors(Resource res) {
        EList errs = res.getErrors();
        if (!errs.isEmpty()) {
            Iterator it = errs.iterator();
            while (it.hasNext()) {
                StandardModelErrorMessageFactory.logErrorMessage((Resource.Diagnostic)it.next());
            }
        }
    }

    protected void setLoadOptions(XMLResource resource) {
        Map options = resource.getDefaultLoadOptions();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        options.put("EXTENDED_META_DATA", this.extendedMetaData);
        options.put("RESOURCE_HANDLER", resource);
        options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.FALSE);
    }

    public static void debug(String msg, boolean debugFlag) {
        if (debugFlag) {
            System.out.println(String.valueOf(msg) + "[" + Thread.currentThread().getId() + "]");
        }
    }

    static class StandardModelErrorMessageFactory {
        private static List<String> _missingPackageURIs;
        private static List<String> _missingClassnames;

        StandardModelErrorMessageFactory() {
        }

        public static void logErrorMessage(Resource.Diagnostic diagnostic) {
            if (diagnostic instanceof XMIException) {
                XMIException ex = (XMIException)diagnostic;
                String msg = StandardModelErrorMessageFactory.createMessage(ex);
                if (msg != null) {
                    JSFCommonPlugin.log(4, msg);
                }
            } else {
                JSFCommonPlugin.log(4, diagnostic.toString());
            }
        }

        private static String createMessage(XMIException ex) {
            StringBuffer buf = new StringBuffer("Metadata Load Error: ").append(ex.getClass().getSimpleName()).append(": ");
            if (ex instanceof PackageNotFoundException) {
                if (StandardModelErrorMessageFactory.shouldIgnore(ex)) {
                    return null;
                }
                buf.append(((PackageNotFoundException)ex).uri());
            } else if (ex instanceof ClassNotFoundException) {
                if (StandardModelErrorMessageFactory.shouldIgnore(ex)) {
                    return null;
                }
                buf.append(((ClassNotFoundException)ex).getName());
            } else if (ex instanceof FeatureNotFoundException) {
                buf.append(((FeatureNotFoundException)ex).getName());
            } else if (ex instanceof IllegalValueException) {
                buf.append(((IllegalValueException)ex).getValue().toString());
            } else if (ex instanceof UnresolvedReferenceException) {
                buf.append(((UnresolvedReferenceException)ex).getReference());
            } else {
                buf.append(ex.getMessage());
            }
            buf.append(" in ").append(ex.getLocation()).append(": Line = ").append(ex.getLine()).append(": Column = ").append(ex.getColumn());
            return buf.toString();
        }

        private static boolean shouldIgnore(XMIException ex) {
            if (ex instanceof PackageNotFoundException) {
                String uri = ((PackageNotFoundException)ex).uri();
                return StandardModelErrorMessageFactory.getMissingPackageURIs().contains(uri);
            }
            if (ex instanceof ClassNotFoundException) {
                String className = ((ClassNotFoundException)ex).getName();
                return StandardModelErrorMessageFactory.getMissingClassnames().contains(className);
            }
            return false;
        }

        private static List<String> getMissingPackageURIs() {
            if (_missingPackageURIs == null) {
                _missingPackageURIs = StandardModelErrorMessageFactory.buildList("metadata.package.ignores");
            }
            return _missingPackageURIs;
        }

        private static List<String> getMissingClassnames() {
            if (_missingClassnames == null) {
                _missingClassnames = StandardModelErrorMessageFactory.buildList("metadata.classname.ignores");
            }
            return _missingClassnames;
        }

        private static List<String> buildList(String propertyName) {
            ArrayList<String> ret = new ArrayList<String>();
            String ignoreSet = System.getProperty(propertyName);
            if (ignoreSet == null) {
                ignoreSet = System.getenv(propertyName);
            }
            if (ignoreSet != null && !ignoreSet.equals("")) {
                StringTokenizer st = new StringTokenizer(ignoreSet, ",");
                while (st.hasMoreTokens()) {
                    String uri = st.nextToken();
                    if (uri.equals("")) continue;
                    ret.add(uri);
                }
            }
            return ret;
        }
    }
}

