/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.xsl.launching.model.NodeListVariable;
import org.eclipse.wst.xsl.launching.model.XSLDebugElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSLValue
extends XSLDebugElement
implements IValue {
    private static final String NODESET = "nodeset";
    private static final String EMPTY_NODESET = "<EMPTY NODESET>";
    private String fValue;
    private String type;
    private boolean hasVariables;
    private Node actualNode;

    public XSLValue(IDebugTarget target, String type, Node node) {
        super(target);
        this.actualNode = node;
        String value = "";
        if (node.getNodeValue() != null) {
            value = node.getNodeValue();
        }
        this.init(target, type, value);
    }

    public XSLValue(IDebugTarget target, String type, String value) {
        super(target);
        this.init(target, type, value);
    }

    private void init(IDebugTarget target, String type, String value) {
        this.type = type;
        this.fValue = value;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public String getValueString() throws DebugException {
        if ("string".equals(this.type)) {
            return "'" + this.fValue + "'";
        }
        return this.fValue;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        if (this.actualNode != null) {
            if (this.actualNode.hasAttributes()) {
                this.getAttributes(variableList, this.actualNode);
            }
            variableList.addAll(this.getNodeListVariables(this.actualNode.getChildNodes()));
        }
        if (this.type.equals(NODESET) && !this.fValue.equals(EMPTY_NODESET)) {
            this.createNodeSetVariables(variableList);
        }
        IVariable[] variables = new IVariable[variableList.size()];
        variableList.toArray(variables);
        return variables;
    }

    private void createNodeSetVariables(List<IVariable> variableList) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        NodeList nodeList = null;
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            String nodeSet = "<nodeset>" + this.fValue + "</nodeset>";
            ByteArrayInputStream is = new ByteArrayInputStream(nodeSet.getBytes());
            Document doc = builder.parse(is);
            Node firstChild = doc.getFirstChild();
            nodeList = firstChild.getChildNodes();
            variableList.addAll(this.getNodeListVariables(nodeList));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<IVariable> getNodeListVariables(NodeList nodeList) {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                NodeListVariable variable = new NodeListVariable(this.getDebugTarget(), node);
                variableList.add(variable);
                ++i;
            }
        }
        return variableList;
    }

    private void getAttributes(List<IVariable> variableList, Node node) {
        NamedNodeMap nodeMap = node.getAttributes();
        int item = 0;
        while (item < nodeMap.getLength()) {
            Attr attribute = (Attr)nodeMap.item(item);
            NodeListVariable variable = new NodeListVariable(this.getDebugTarget(), attribute);
            variableList.add(variable);
            ++item;
        }
    }

    public boolean hasVariables() throws DebugException {
        this.hasVariables = false;
        this.hasVariables = this.actualNode != null ? this.actualNode.hasChildNodes() : this.type.equals(NODESET);
        if (this.fValue.equals(EMPTY_NODESET)) {
            this.hasVariables = false;
        }
        return this.hasVariables;
    }
}

