/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPADiagramEditorInput;

public class JPADiagramEditorInput
extends DiagramEditorInput
implements IJPADiagramEditorInput {
    private Diagram diagram;
    private String projectName;

    public JPADiagramEditorInput(Diagram diagram, URI diagramUri, String providerId) {
        super(diagramUri, providerId);
        this.diagram = diagram;
        this.projectName = ModelIntegrationUtil.getProjectByDiagram(diagram.getName()).getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(EObject.class)) {
            return this.getDiagram();
        }
        if (adapter.equals(Diagram.class)) {
            return this.getDiagram();
        }
        if (adapter.equals(TransactionalEditingDomain.class)) {
            return ModelIntegrationUtil.getTransactionalEditingDomain(this.diagram);
        }
        if (adapter.equals(IFile.class)) {
            Resource eResource = this.diagram.eResource();
            URI eUri = eResource.getURI();
            if (eUri.isPlatformResource()) {
                String platformString = eUri.toPlatformString(true);
                return ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            }
            IProject project = ModelIntegrationUtil.getProjectByDiagram(this.diagram.getName()).getProject();
            return this.findXMLFile(project);
        }
        return null;
    }

    private IFile findXMLFile(IProject project) {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile existingXMLFile;
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder && (existingXMLFile = ((IFolder)res).getFile(String.valueOf(this.diagram.getName()) + "." + "xml")) != null && existingXMLFile.exists()) {
                    return existingXMLFile;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.logError(JPAEditorMessages.EntitiesCoordinatesXML_CannotObtainProjectErrorMSG, e);
        }
        IFile existingXMLFile = project.getFile(ModelIntegrationUtil.getDiagramsXMLFolderPath(project).append(this.diagram.getName()).addFileExtension("xml"));
        if (existingXMLFile != null && existingXMLFile.exists()) {
            return existingXMLFile;
        }
        return null;
    }

    @Override
    public Diagram getDiagram() {
        return this.diagram;
    }

    public static JPADiagramEditorInput createEditorInput(Diagram diagram, String providerId) {
        Resource resource = diagram.eResource();
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        String fragment = resource.getURIFragment((EObject)diagram);
        URI fragmentUri = resource.getURI().appendFragment(fragment);
        JPADiagramEditorInput diagramEditorInput = new JPADiagramEditorInput(diagram, fragmentUri, providerId);
        return diagramEditorInput;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }
}

