/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.tests.model.WorkingCopyTests;

public class HierarchyOnWorkingCopiesTests
extends WorkingCopyTests {
    public HierarchyOnWorkingCopiesTests(String name) {
        super(name);
    }

    public static Test suite() {
        return HierarchyOnWorkingCopiesTests.buildModelTestSuite(HierarchyOnWorkingCopiesTests.class);
    }

    public void testSimpleSubTypeHierarchy() throws CoreException {
        String newContents = "function A(){}\nA.prototype = new B()\n";
        this.copy.getBuffer().setContents(newContents);
        this.copy.reconcile(0, false, null, null);
        IFile file = null;
        try {
            file = this.createFile("P/src/x/y/B.js", "function B() {}\n");
            IType type = this.getCompilationUnit("P/src/x/y/B.js").getType("B");
            ITypeHierarchy h = type.newTypeHierarchy(new IJavaScriptUnit[]{this.copy}, null);
            this.assertHierarchyEquals("Focus: B [in B.js [in x.y [in src [in P]]]]\nSuper types:\n  Object [in System.js [in java.lang [in " + this.getSystemJsPathString() + " [in P]]]]\n" + "Sub types:\n" + "  A [in [Working copy] A.js [in x.y [in src [in P]]]]\n", h);
        }
        finally {
            if (file != null) {
                this.deleteResource((IResource)file);
            }
        }
    }

    public void testSimpleSuperTypeHierarchy() throws CoreException {
        String newContents = "function A() {this.a = 1;}\nfunction B(this.b = 2;) {\n}";
        this.copy.getBuffer().setContents(newContents);
        this.copy.reconcile(0, false, null, null);
        IFile file = null;
        try {
            file = this.createFile("P/src/x/y/C.js", "function C() {} {\nC.prototype = new B();");
            IType type = this.getCompilationUnit("P/src/x/y/C.js").getType("C");
            ITypeHierarchy h = type.newSupertypeHierarchy(new IJavaScriptUnit[]{this.copy}, null);
            this.assertHierarchyEquals("Focus: C [in C.js [in x.y [in src [in P]]]]\nSuper types:\n  B [in [Working copy] A.js [in x.y [in src [in P]]]]\n    Object [in Object.class [in java.lang [in " + this.getSystemJsPathString() + " [in P]]]]\n" + "Sub types:\n", h);
        }
        finally {
            if (file != null) {
                this.deleteResource((IResource)file);
            }
        }
    }
}

