/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadConverterTestCase
extends BaseReadTestCase {
    public ReadConverterTestCase(String name) {
        super(name);
    }

    public void testSingleConverter() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadConverterTestCase.assertNotNull((Object)this.getConverter1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    ConverterType getConverter1(FacesConfigType facesConfig) {
        return (ConverterType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getConverter(), "converter1");
    }

    private ConverterType getConverter2(FacesConfigType facesConfig) {
        return (ConverterType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getConverter(), "converter2");
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ConverterType converter1 = this.getConverter1(edit.getFacesConfig());
            ReadConverterTestCase.assertNotNull((Object)converter1);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)converter1.getDescription(), "converter1Description");
            ReadConverterTestCase.assertEquals((String)"converter-description", (String)descType.getTextContent());
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)converter1.getDisplayName(), "converter1DisplayName");
            ReadConverterTestCase.assertEquals((String)"converter-display-name", (String)displayNameType.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)converter1.getIcon(), "converter1Icon");
            ReadConverterTestCase.assertEquals((String)"converter-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadConverterTestCase.assertEquals((String)"converter-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testValidatorSingleValueProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ConverterType converter1 = this.getConverter1(edit.getFacesConfig());
            ReadConverterTestCase.assertNotNull((Object)converter1);
            ReadConverterTestCase.assertEquals((String)"converter-for-class", (String)converter1.getConverterForClass().getTextContent());
            ReadConverterTestCase.assertEquals((String)"converter-class", (String)converter1.getConverterClass().getTextContent());
            ConverterType converter2 = this.getConverter2(edit.getFacesConfig());
            ReadConverterTestCase.assertNotNull((Object)converter2);
            ReadConverterTestCase.assertEquals((String)"converter2-id", (String)converter2.getConverterId().getTextContent());
            ReadConverterTestCase.assertEquals((String)"converter2-class", (String)converter2.getConverterClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ConverterType converter1 = this.getConverter1(edit.getFacesConfig());
            ReadConverterTestCase.assertEquals((int)1, (int)converter1.getAttribute().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            ConverterType converter1 = this.getConverter1(edit.getFacesConfig());
            ReadConverterTestCase.assertEquals((int)1, (int)converter1.getProperty().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

