/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;

public class RunOnCompletionPattern
implements Runnable {
    private final Job _job;
    private final Runnable _runAfter;

    public RunOnCompletionPattern(Job job, Runnable runAfter) {
        this._job = job;
        this._runAfter = runAfter;
    }

    @Override
    public void run() {
        if (this._runAfter != null) {
            this._job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().getSeverity() != 4) {
                        RunOnCompletionPattern.this._runAfter.run();
                    }
                }
            });
        }
        this._job.schedule();
        if (this._runAfter == null) {
            try {
                this._job.join();
            }
            catch (InterruptedException e) {
                JSFCommonPlugin.log(e, "Joining on job");
            }
        }
    }
}

